VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Object = "{A5849E73-E55F-11D3-AF35-00400565C94E}#2.0#0"; "RSTimer.ocx"
Begin VB.Form MainFrm 
   Appearance      =   0  'Flat
   Caption         =   "VB-STEPPER EXAMPLE"
   ClientHeight    =   6240
   ClientLeft      =   240
   ClientTop       =   1650
   ClientWidth     =   11010
   BeginProperty Font 
      Name            =   "MS Sans Serif"
      Size            =   8.25
      Charset         =   0
      Weight          =   700
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   ForeColor       =   &H00000000&
   HelpContextID   =   1
   Icon            =   "mainfrm.frx":0000
   LinkTopic       =   "Form1"
   PaletteMode     =   1  'UseZOrder
   Picture         =   "mainfrm.frx":030A
   ScaleHeight     =   6240
   ScaleWidth      =   11010
   Begin VB.Frame Frame1 
      Caption         =   "Kit KT-5192 Limit Switches"
      Height          =   1455
      Left            =   240
      TabIndex        =   44
      Top             =   4440
      Width           =   6255
      Begin VB.CheckBox ChkLimit4 
         Caption         =   "Limit 4"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   4920
         TabIndex        =   51
         Top             =   840
         Width           =   1095
      End
      Begin VB.CheckBox ChkLimit3 
         Caption         =   "Limit 3"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   3480
         TabIndex        =   50
         Top             =   840
         Width           =   1095
      End
      Begin VB.CheckBox ChkLimit2 
         Caption         =   "Limit 2"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   1800
         TabIndex        =   49
         Top             =   840
         Width           =   1095
      End
      Begin VB.CheckBox ChkLimit1 
         Caption         =   "Limit 1"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   240
         TabIndex        =   48
         Top             =   840
         Width           =   1095
      End
      Begin VB.CommandButton CmdStatus 
         Caption         =   "Read Status Inputs"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Left            =   3720
         TabIndex        =   47
         Top             =   240
         Width           =   1935
      End
      Begin VB.TextBox TxtStatus 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Left            =   1320
         TabIndex        =   45
         Top             =   360
         Width           =   1455
      End
      Begin VB.Label Label4 
         Caption         =   "Status Port"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   240
         TabIndex        =   46
         Top             =   360
         Width           =   1095
      End
   End
   Begin VB.TextBox TxtAccelIncrement 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   285
      Index           =   4
      Left            =   6840
      TabIndex        =   42
      Top             =   3000
      Width           =   735
   End
   Begin VB.TextBox TxtAccelIncrement 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   285
      Index           =   3
      Left            =   6840
      TabIndex        =   41
      Top             =   2520
      Width           =   735
   End
   Begin VB.TextBox TxtAccelIncrement 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   285
      Index           =   2
      Left            =   6840
      TabIndex        =   40
      Top             =   2040
      Width           =   735
   End
   Begin VB.TextBox TxtAccelIncrement 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   285
      Index           =   1
      Left            =   6840
      TabIndex        =   39
      Top             =   1560
      Width           =   735
   End
   Begin RSTIMERLib.RSTimer RSTimer1 
      Left            =   7560
      Top             =   0
      _Version        =   131073
      _ExtentX        =   847
      _ExtentY        =   847
      _StockProps     =   64
      Interval        =   1
   End
   Begin VB.CommandButton CmdStop 
      Caption         =   "Stop 3"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Index           =   4
      Left            =   9480
      TabIndex        =   38
      Top             =   3000
      Width           =   1335
   End
   Begin VB.CommandButton CmdStop 
      Caption         =   "Stop 3"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Index           =   3
      Left            =   9480
      TabIndex        =   37
      Top             =   2520
      Width           =   1335
   End
   Begin VB.CommandButton CmdStop 
      Caption         =   "Stop 2"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Index           =   2
      Left            =   9480
      TabIndex        =   36
      Top             =   2040
      Width           =   1335
   End
   Begin VB.CommandButton CmdStop 
      Caption         =   "Stop 1"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Index           =   1
      Left            =   9480
      TabIndex        =   35
      Top             =   1560
      Width           =   1335
   End
   Begin VB.TextBox TxtOut 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   285
      Left            =   1440
      TabIndex        =   33
      Top             =   3720
      Width           =   1455
   End
   Begin VB.ComboBox CboFullHalf 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   315
      Left            =   5400
      TabIndex        =   31
      Top             =   240
      Width           =   1935
   End
   Begin VB.ComboBox CboStepType 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   315
      Left            =   1320
      TabIndex        =   29
      Text            =   "K179 Unipolar Stepper"
      Top             =   240
      Width           =   3015
   End
   Begin VB.TextBox TxtAccel 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   285
      Index           =   4
      Left            =   5880
      TabIndex        =   28
      Top             =   3000
      Width           =   735
   End
   Begin VB.TextBox TxtAccel 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   285
      Index           =   3
      Left            =   5880
      TabIndex        =   27
      Top             =   2520
      Width           =   735
   End
   Begin VB.TextBox TxtAccel 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   285
      Index           =   2
      Left            =   5880
      TabIndex        =   26
      Top             =   2040
      Width           =   735
   End
   Begin VB.TextBox TxtRate 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   285
      Index           =   4
      Left            =   4920
      TabIndex        =   25
      Top             =   3000
      Width           =   735
   End
   Begin VB.TextBox TxtRate 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   285
      Index           =   3
      Left            =   4920
      TabIndex        =   24
      Top             =   2520
      Width           =   735
   End
   Begin VB.TextBox TxtRate 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   285
      Index           =   2
      Left            =   4920
      TabIndex        =   23
      Top             =   2040
      Width           =   735
   End
   Begin VB.TextBox TxtAccel 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   285
      Index           =   1
      Left            =   5880
      TabIndex        =   22
      Top             =   1560
      Width           =   735
   End
   Begin VB.TextBox TxtRate 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   285
      Index           =   1
      Left            =   4920
      TabIndex        =   21
      Top             =   1560
      Width           =   735
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Run 4"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Index           =   4
      Left            =   7920
      TabIndex        =   19
      Top             =   3000
      Width           =   1335
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Run 3"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Index           =   3
      Left            =   7920
      TabIndex        =   18
      Top             =   2520
      Width           =   1335
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Run 2"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Index           =   2
      Left            =   7920
      TabIndex        =   17
      Top             =   2040
      Width           =   1335
   End
   Begin VB.TextBox TxtPosition 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   285
      Index           =   4
      Left            =   3600
      MultiLine       =   -1  'True
      TabIndex        =   16
      Top             =   3000
      Width           =   975
   End
   Begin VB.TextBox TxtPosition 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   285
      Index           =   3
      Left            =   3600
      MultiLine       =   -1  'True
      TabIndex        =   15
      Top             =   2520
      Width           =   975
   End
   Begin VB.TextBox TxtPosition 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   285
      Index           =   2
      Left            =   3600
      MultiLine       =   -1  'True
      TabIndex        =   14
      Top             =   2040
      Width           =   975
   End
   Begin VB.TextBox TxtCommand 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   285
      Index           =   4
      Left            =   1440
      TabIndex        =   13
      Text            =   "POSN 1000"
      Top             =   3000
      Width           =   1935
   End
   Begin VB.TextBox TxtCommand 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   285
      Index           =   3
      Left            =   1440
      TabIndex        =   12
      Text            =   "STOP"
      Top             =   2520
      Width           =   1935
   End
   Begin VB.TextBox TxtCommand 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   285
      Index           =   2
      Left            =   1440
      TabIndex        =   11
      Text            =   "RMOV 1000"
      Top             =   2040
      Width           =   1935
   End
   Begin VB.TextBox TxtPosition 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   285
      Index           =   1
      Left            =   3600
      MultiLine       =   -1  'True
      TabIndex        =   8
      Top             =   1560
      Width           =   975
   End
   Begin VB.TextBox TxtCommand 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   285
      Index           =   1
      Left            =   1440
      TabIndex        =   7
      Text            =   "RMOV -500"
      Top             =   1560
      Width           =   1935
   End
   Begin VB.CommandButton Command3 
      Caption         =   "Exit"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   8040
      TabIndex        =   2
      Top             =   3720
      Width           =   1455
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Run 1"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Index           =   1
      Left            =   7920
      TabIndex        =   1
      Top             =   1560
      Width           =   1335
   End
   Begin MSComDlg.CommonDialog CMDialog1 
      Left            =   8280
      Top             =   0
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
      FontSize        =   0
      MaxFileSize     =   256
   End
   Begin VB.Label Label3 
      Caption         =   "Accel Increment"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   6840
      TabIndex        =   43
      Top             =   960
      Width           =   735
   End
   Begin VB.Label Label1 
      Caption         =   "Port Output"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   360
      TabIndex        =   34
      Top             =   3720
      Width           =   1095
   End
   Begin VB.Label LblFullHalf 
      Caption         =   "Step Type"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   4560
      TabIndex        =   32
      Top             =   240
      Width           =   855
   End
   Begin VB.Label CboType 
      Caption         =   "Kit Type"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   480
      TabIndex        =   30
      Top             =   240
      Width           =   735
   End
   Begin VB.Label Label9 
      Caption         =   "Start Period"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   5880
      TabIndex        =   20
      Top             =   960
      Width           =   735
   End
   Begin VB.Label Label8 
      Caption         =   "Position"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   3600
      TabIndex        =   10
      Top             =   1200
      Width           =   1095
   End
   Begin VB.Label Label7 
      Caption         =   "Command"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   1680
      TabIndex        =   9
      Top             =   1200
      Width           =   1095
   End
   Begin VB.Label LblStep4 
      Caption         =   "Stepper 4"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   360
      TabIndex        =   6
      Top             =   3000
      Width           =   1095
   End
   Begin VB.Label LblStep3 
      Caption         =   "Stepper 3"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   360
      TabIndex        =   5
      Top             =   2520
      Width           =   1095
   End
   Begin VB.Label LblStep2 
      Caption         =   "Stepper 2"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   360
      TabIndex        =   4
      Top             =   2040
      Width           =   1095
   End
   Begin VB.Label LblStep1 
      Caption         =   "Stepper 1"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   360
      TabIndex        =   3
      Top             =   1560
      Width           =   1095
   End
   Begin VB.Label Label2 
      Caption         =   "Step Interval"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   5040
      TabIndex        =   0
      Top             =   960
      Width           =   735
   End
   Begin VB.Menu PrinterPort 
      Caption         =   "&PrinterPort"
      Begin VB.Menu PrinterAddress 
         Caption         =   "&Address"
      End
   End
   Begin VB.Menu Help 
      Caption         =   "&Help"
   End
End
Attribute VB_Name = "MainFrm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Dim NewInterval, Interval, Cnt As Integer

' Commands are of the form

'   AMOV xxxx Absolute Move to location xxxx
'   RMOV xxxx Relative Move to current location + xxxx
'   POSN xxxx It is position xxxx
'   STOP xxxx
'   STAT      Status bit 0=stepper 1 direction, 0=stepper 1 moving etc
'   RATE xx   Rate steps in msec
'   ACCN xx   Acceleration Starts off with this interval and decrements interval by ACCEL_INCREMENT
'   ACCI xx   Acceleration Increment. The step period increases and decreases by this amount during acceleration and deceleration
'   DIRN  x   NOT USED Direction x=1 or -1
Dim iStep_Accel(1 To 4)
Dim iAccel_Increment(1 To 4)
Dim iStep_Dir(1 To 4)
Dim iStep_Moving(1 To 4) As Boolean
Dim lStep_Curr_Posn(1 To 4)
Dim lStep_Target_Posn(1 To 4)
Dim iStep_Period(1 To 4) As Integer
Dim iStep_Curr_Interval(1 To 4) As Integer
Dim iStep_Interval(1 To 4) As Integer
Dim iStep_Polar(1 To 4) As Integer   'Current polarity of Step
Dim iStep_Start(1 To 4) As Boolean   'Flag to indicate start
Dim HalfStep(1 To 4) As Integer

Dim WAVE(0 To 7) As Integer         'K113 Array
Dim TWO_PHASE(0 To 7) As Integer    'K113 Array
Dim h_step(0 To 7) As Integer       'K113 Array




Dim bFlag As Boolean

Const BADARG = 4
Const BAD_COMMAND = 5
Const MOTOR_NAME = 6
Const STEP_VALUE = 7
Const DIRECTION = 8
Const STEPRATE = 9
Const Delay = 10
Const INPUT1 = 11
Const INPUT2 = 12
Const ON_OFF = 13

Private Sub FileExit_Click()
    Unload Me 'MainFrm
End Sub



Private Sub CboFullHalf_Click()
    If CboFullHalf.Text = "Two Phase Sequence" Then
        gFullHalf = TWO_PHASE_SEQ
    End If
    If CboFullHalf.Text = "Wave Sequence" Then
        gFullHalf = WAVE_SEQ
    End If
    If CboFullHalf.Text = "Half Step Sequence" Then
        gFullHalf = HALF_STEP_SEQ
    End If
    

End Sub

Private Sub CboStepType_Click()
Dim i As Integer
    If CboStepType.Text = "K113 Dual Unipolar Stepper" Then
        gStepType = K113
        For i = 3 To 4
            TxtCommand(i%).Visible = False
            TxtPosition(i%).Visible = False
            TxtRate(i%).Visible = False
            TxtAccel(i%).Visible = False
            Command1(i%).Visible = False
        Next i
        LblStep3.Visible = False
        LblStep4.Visible = False
        LblFullHalf.Visible = True
        CboFullHalf.Visible = True
    End If
    If CboStepType.Text = "K158 Bipolar Stepper" Then
        gStepType = K158
        For i = 3 To 4
            TxtCommand(i%).Visible = True
            TxtPosition(i%).Visible = True
            TxtRate(i%).Visible = True
            TxtAccel(i%).Visible = True
            Command1(i%).Visible = True
        Next i
        LblStep3.Visible = True
        LblStep4.Visible = True
        LblFullHalf.Visible = False
        CboFullHalf.Visible = False
    End If
    If CboStepType.Text = "K179 Unipolar Stepper" Then
        gStepType = K179
        For i = 3 To 4
            TxtCommand(i%).Visible = True
            TxtPosition(i%).Visible = True
            TxtRate(i%).Visible = True
            TxtAccel(i%).Visible = True
            Command1(i%).Visible = True
        Next i
        LblStep3.Visible = True
        LblStep4.Visible = True
        LblFullHalf.Visible = False
        CboFullHalf.Visible = False
    End If
End Sub

Private Sub CmdStatus_Click()
Dim Dig_IPs As Byte
Dim iBit As Byte
    Dig_IPs = Inp(LPTStatus%)
    TxtStatus.Text = Hex$(Dig_IPs)
    iBit = Dig_IPs And &H8
    ChkLimit1.Value = vbUnchecked
    If iBit <> 0 Then ChkLimit1.Value = vbChecked
    iBit = Dig_IPs And &H10
    ChkLimit2.Value = vbUnchecked
    If iBit <> 0 Then ChkLimit2.Value = vbChecked
    iBit = Dig_IPs And &H20
    ChkLimit3.Value = vbUnchecked
    If iBit <> 0 Then ChkLimit3.Value = vbChecked
    iBit = Dig_IPs And &H40
    ChkLimit4.Value = vbUnchecked
    If iBit <> 0 Then ChkLimit4.Value = vbChecked
    
End Sub

Private Sub CmdStop_Click(Index As Integer)
    iStep_Moving(Index) = False
    lStep_Target_Posn(Index) = lStep_Curr_Posn(Index)

End Sub

Private Sub Command1_Click(Index As Integer)
Dim sCmd$
Dim sAddr$
Dim sS$
Dim iAddr
Dim sParam1$, sParam2$, sParam3$
Dim lParam1 As Long
Dim iStatus As Integer
Dim temp1 As Long
Dim temp2 As Long

Dim input_mask As Integer
Dim bGo As Boolean
Dim i%, j%
    If iStep_Moving(Index) = False Then
        If IsNumeric(TxtRate(Index).Text) Then
            iStep_Interval(Index) = Val(TxtRate(Index).Text)
        End If
        If IsNumeric(TxtAccel(Index).Text) Then
           iStep_Accel(Index) = Val(TxtAccel(Index).Text)
        End If
        If IsNumeric(TxtAccelIncrement(Index).Text) Then
           iAccel_Increment(Index) = Val(TxtAccelIncrement(Index).Text)
        End If
        If IsNumeric(TxtPosition(Index).Text) Then
            lStep_Curr_Posn(Index) = Val(TxtPosition(Index).Text)
        End If
    End If
  
    sS$ = UCase(TxtCommand(Index).Text)
    sCmd$ = ""
    sParam1$ = ""
    sParam2$ = ""
    sCmd$ = Mid(sS$, 1, 4)
    sParam1$ = Mid(sS$, 5)
    If IsNumeric(sParam1$) Then
        lParam1 = Val(sParam1$)
    End If
    iAddr = Index
        Select Case sCmd$
              Case "ACCN":      'Acceleration Start Period
                If iStep_Moving(iAddr) = False Then
                    If lParam1 >= 0 Then
                        iStep_Accel(iAddr) = lParam1
                        TxtCommand(iAddr).Text = ""
                        TxtAccel(iAddr).Text = lParam1
                    End If
                End If
              Case "ACCI":      'Acceleration Increment
                If iStep_Moving(iAddr) = False Then
                    If lParam1 >= 0 Then
                        iAccel_Increment(iAddr) = lParam1
                        TxtCommand(iAddr).Text = ""
                        TxtAccelIncrement(iAddr).Text = lParam1
                    End If
                End If
                          
              Case "POSN":
                If iStep_Moving(iAddr) = False Then
                    lStep_Target_Posn(iAddr) = lParam1
                    lStep_Curr_Posn(iAddr) = lParam1
                    TxtPosition(iAddr) = lParam1
                End If
              Case "RATE":
                If lParam1 > 0 Then
                    iStep_Interval(iAddr) = lParam1
                    TxtRate(iAddr).Text = lParam1
                End If
              
              Case "STAT":
                iStatus = 0
                If iStep_Moving(1) = True Then iStatus = iStatus Or 1
                If iStep_Moving(2) = True Then iStatus = iStatus Or 2
                If iStep_Moving(3) = True Then iStatus = iStatus Or 4
                If iStep_Moving(4) = True Then iStatus = iStatus Or 8
                
              Case "AMOV":      'Absolute move
                If iStep_Moving(iAddr) = False Then
                    If lParam1 > 0 Or lParam1 < 0 Then
                        lStep_Target_Posn(iAddr) = lParam1
                        iStep_Moving(iAddr) = True
                        iStep_Start(iAddr) = True
                    End If
                End If
             
             Case "RMOV":   'Relative Move
                If iStep_Moving(iAddr) = False Then
                    If lParam1 > 0 Then
                        lStep_Target_Posn(iAddr) = lStep_Curr_Posn(iAddr) + lParam1
                        iStep_Moving(iAddr) = True
                        iStep_Start(iAddr) = True
                    End If
                    If lParam1 < 0 Then
                        lStep_Target_Posn(iAddr) = lStep_Curr_Posn(iAddr) + lParam1
                        iStep_Moving(iAddr) = True
                        iStep_Start(iAddr) = True
                    End If
                End If
               
               Case "STOP":
                    iStep_Moving(iAddr) = False
                    lStep_Target_Posn(iAddr) = lStep_Curr_Posn(iAddr)
               
        End Select
    
End Sub

Private Sub Command2_Click()

End Sub

Private Sub Command3_Click()
    Unload Me
End Sub

Private Sub Form_Load()
Dim i%, j%
Dim SufDir$
Dim bStatus As Boolean
    Left = (Screen.Width - Width) / 2
    Top = (Screen.Height - Height) / 2
    For i% = 1 To 4
        iStep_Interval(i%) = 40
        iStep_Accel(i%) = 80
        iAccel_Increment(i%) = 10
        lStep_Target_Posn(i%) = 0
        lStep_Curr_Posn(i%) = 0
        iStep_Dir(i%) = 0
        TxtRate(i%).Text = iStep_Interval(i%)
        TxtAccel(i%).Text = iStep_Accel(i%)
        TxtAccelIncrement(i%).Text = iAccel_Increment(i%)
    Next i%
    WriteDOPs (0)
    
    'TxtCmd.Text = ""
    TxtPosition(1).Text = lStep_Curr_Posn(1)
    TxtPosition(2).Text = lStep_Curr_Posn(2)
    TxtPosition(3).Text = lStep_Curr_Posn(3)
    TxtPosition(4).Text = lStep_Curr_Posn(4)

    'Stepper Kit Type Default K179
    gStepType = K179
    CboStepType.Clear
    CboStepType.AddItem "K113 Dual Unipolar Stepper"
    CboStepType.AddItem "K158 Bipolar Stepper"
    CboStepType.AddItem "K179 Unipolar Stepper"
    CboStepType.Text = "K179 Unipolar Stepper"
    
    'Hide K113 Controls
    CboFullHalf.Clear
    CboFullHalf.AddItem "Two Phase Sequence"
    CboFullHalf.AddItem "Wave Sequence"
    CboFullHalf.AddItem "Half Step Sequence"
    CboFullHalf.Text = "Two Phase Sequence"
    LblFullHalf.Visible = False
    CboFullHalf.Visible = False

'K113 Drive tables
    WAVE(0) = &H88
    WAVE(1) = &H44
    WAVE(2) = &H22
    WAVE(3) = &H11
    WAVE(4) = &H88
    WAVE(5) = &H44
    WAVE(6) = &H22
    WAVE(7) = &H11

    TWO_PHASE(0) = &HCC
    TWO_PHASE(1) = &H66
    TWO_PHASE(2) = &H33
    TWO_PHASE(3) = &H99
    TWO_PHASE(4) = &HCC
    TWO_PHASE(5) = &H66
    TWO_PHASE(6) = &H33
    TWO_PHASE(7) = &H99

    h_step(0) = &H99
    h_step(1) = &H88
    h_step(2) = &HCC
    h_step(3) = &H44
    h_step(4) = &H66
    h_step(5) = &H22
    h_step(6) = &H33
    h_step(7) = &H11
    
'Install the Parallel Port Driver
    bStatus = IsDriverInstalled()
    If Not bStatus Then
        MsgBox "ERROR Parallel Port Driver cannot Initialise - Aborting Program"
        'Unload Me
        'Exit Sub
    End If
    
    'TxtRate.Text = 50
    LPTNo% = 1
    LptPortAddr% = 0
End Sub

Private Sub Help_Click()
Dim HELP_CONTEXT
    HELP_CONTEXT = &H101
    CMDialog1.HelpFile = "vb_stepper.HLP"   ' Specify the Help file to open.
    CMDialog1.HelpCommand = HELP_CONTEXT ' When WINHELP.EXE is executed, Help for a specified keyword will be displayed.
    CMDialog1.HelpKey = "Introduction" ' Specify the keyword.
    CMDialog1.Action = 6    ' Execute WINHELP.EXE.
End Sub




Sub Write_Stepper()
Dim Dig_OPs As Integer
Dim i%
Static iOld_Step_Polar(1 To 4) As Integer

  
  Dig_OPs = 0
  Call AWait(gSpeed&)

  If (iStep_Polar(1) = 1) Then Dig_OPs = Dig_OPs Or 1
  If (iStep_Dir(1) = 0) Then Dig_OPs = Dig_OPs Or 2
  If (iStep_Polar(2) = 1) Then Dig_OPs = Dig_OPs Or 4
  If (iStep_Dir(2) = 0) Then Dig_OPs = Dig_OPs Or 8
  If (iStep_Polar(3) = 1) Then Dig_OPs = Dig_OPs Or 16
  If (iStep_Dir(3) = 0) Then Dig_OPs = Dig_OPs Or 32
  If (iStep_Polar(4) = 1) Then Dig_OPs = Dig_OPs Or 64
  If (iStep_Dir(4) = 0) Then Dig_OPs = Dig_OPs Or 128
  
  TxtOut.Text = Hex$(Dig_OPs)
  WriteDOPs (Dig_OPs)
  For i% = 1 To 4
    iOld_Step_Polar(i%) = iStep_Polar(i%)
  Next i%

End Sub

Sub Write_K113_Stepper()
Static Dig_OPs As Integer
Dim i%
Dim Step_Motor1 As Integer
Dim Step_Motor2 As Integer
Static iOld_Step_Polar(1 To 4) As Integer
Static Step_K113_1 As Integer
Static Step_K113_2 As Integer
      
    If (iStep_Polar(1) = 1) And (iOld_Step_Polar(1) = 0) Then
        If gFullHalf = TWO_PHASE_SEQ Then
            Step_Motor1 = TWO_PHASE(Step_K113_1) And &HF
        End If
        If gFullHalf = WAVE_SEQ Then
            Step_Motor1 = WAVE(Step_K113_1) And &HF
        End If
        If gFullHalf = HALF_STEP_SEQ Then
            Step_Motor1 = h_step(Step_K113_1) And &HF
        End If
        Dig_OPs = Dig_OPs And &HF0
        Dig_OPs = Dig_OPs Or Step_Motor1
        If (iStep_Dir(1) = 0) Then
            Step_K113_1 = Step_K113_1 + 1
            If Step_K113_1 >= 7 Then
                Step_K113_1 = 0
            End If
        Else
            Step_K113_1 = Step_K113_1 - 1
            If Step_K113_1 < 0 Then
                Step_K113_1 = 7
            End If
        End If
     End If
    If (iStep_Polar(2) = 1) And (iOld_Step_Polar(2) = 0) Then
        If gFullHalf = TWO_PHASE_SEQ Then
            Step_Motor2 = TWO_PHASE(Step_K113_2) And &HF0
        End If
        If gFullHalf = WAVE_SEQ Then
            Step_Motor2 = WAVE(Step_K113_2) And &HF0
        End If
        If gFullHalf = HALF_STEP_SEQ Then
            Step_Motor2 = h_step(Step_K113_2) And &HF0
        End If
        Dig_OPs = Dig_OPs And &HF
        Dig_OPs = Dig_OPs Or Step_Motor2
        If (iStep_Dir(2) = 0) Then
            Step_K113_2 = Step_K113_2 + 1
            If Step_K113_2 >= 7 Then
                Step_K113_2 = 0
            End If
        Else
            Step_K113_2 = Step_K113_2 - 1
            If Step_K113_2 < 0 Then
                Step_K113_2 = 7
            End If
        End If
     End If
  TxtOut.Text = Hex$(Dig_OPs)
  WriteDOPs (Dig_OPs)
    For i% = 1 To 4
    iOld_Step_Polar(i%) = iStep_Polar(i%)
  Next i%

End Sub

Private Sub PrinterAddress_Click()
    PrinterAddr.Show
    Call InitPrinterPort(LPTNo%, LptPortAddr%)
End Sub


Sub Wait_Delay(Val%)
    While (Val% > 0)
        DoEvents
        If bFlag = True Then
            Val% = Val% - 1
            bFlag = False
        End If
    Wend
End Sub

Private Sub RSTimer1_Timer()
Dim Reg%
Dim Next_Step As Boolean
Dim TempHalf1 As Long
Dim TempHalf2 As Long
Dim lDiff As Long
Dim j%
Dim iStage(1 To 4) As Integer

    For j% = 1 To 4
        iStage(j%) = 0
    Next j
  'Carry out Stepper 1 command
  For j% = 1 To 4
    If (iStep_Start(j%) = True) Then
        If iStep_Accel(j%) > iStep_Interval(j%) Then
            If (lStep_Target_Posn(j%) > lStep_Curr_Posn(j%)) Then
                TempHalf1 = (lStep_Target_Posn(j%) - lStep_Curr_Posn(j%)) / 2
            Else
                TempHalf1 = (lStep_Curr_Posn(j%) - lStep_Target_Posn(j%)) / 2
            End If
            TempHalf2 = (iStep_Accel(j%) - iStep_Interval(j%)) / iAccel_Increment(j%)
            HalfStep(j%) = TempHalf1
            If (TempHalf2 < TempHalf1) And TempHalf2 > 0 Then HalfStep(j%) = TempHalf2
        Else
            HalfStep(j%) = 0
        End If
    
        iStep_Start(j%) = False
        iStep_Curr_Interval(j%) = iStep_Accel(j%)
    End If
      
    If (lStep_Target_Posn(j%) >= lStep_Curr_Posn(j%)) Then
        iStep_Dir(j%) = 0
    Else
        iStep_Dir(j%) = 1
    End If
  
    If (iStep_Moving(j%) = True) Then
        If iStep_Polar(j%) = 0 Then
            Next_Step = True
        Else
            iStep_Period(j%) = iStep_Period(j%) - 1
            If iStep_Period(j%) <= 0 Then Next_Step = True
        End If
    
        If Next_Step = True Then
            Next_Step = False
            iStep_Period(j%) = 0
            If (lStep_Target_Posn(j%) <> lStep_Curr_Posn(j%)) And iStep_Polar(j%) = 1 And iStage(j%) = 0 Then
                iStep_Polar(j%) = 0
                iStage(j%) = 1
            End If
            If (lStep_Target_Posn(j%) > lStep_Curr_Posn(j%)) And iStep_Polar(j%) = 0 And iStage(j%) = 0 Then
                iStage(j%) = 1
                iStep_Polar(j%) = 1
                lStep_Curr_Posn(j%) = lStep_Curr_Posn(j%) + 1
                lDiff = lStep_Target_Posn(j%) - lStep_Curr_Posn(j%)
                If lDiff > HalfStep(j%) Then
                    iStep_Curr_Interval(j%) = iStep_Curr_Interval(j%) - iAccel_Increment(j%)
                Else   'Start Decceleration
                    iStep_Curr_Interval(j%) = iStep_Curr_Interval(j%) + iAccel_Increment(j%)
                End If
                If iStep_Curr_Interval(j%) < iStep_Interval(j%) Then iStep_Curr_Interval(j%) = iStep_Interval(j%)
                iStep_Period(j%) = iStep_Curr_Interval(j%)
                TxtPosition(j%).Text = lStep_Curr_Posn(j%)
            End If
            If (lStep_Target_Posn(j%) < lStep_Curr_Posn(j%)) And iStep_Polar(j%) = 0 And iStage(j%) = 0 Then
                iStage(j%) = 1
                iStep_Polar(j%) = 1
                lStep_Curr_Posn(j%) = lStep_Curr_Posn(j%) - 1
                lDiff = lStep_Curr_Posn(j%) - lStep_Target_Posn(j%)
                If lDiff > HalfStep(j%) Then
                    iStep_Curr_Interval(j%) = iStep_Curr_Interval(j%) - iAccel_Increment(j%)
                Else   'Start Decceleration
                    iStep_Curr_Interval(j%) = iStep_Curr_Interval(j%) + iAccel_Increment(j%)
                End If
                If iStep_Curr_Interval(j%) < iStep_Interval(j%) Then iStep_Curr_Interval(j%) = iStep_Interval(j%)
                iStep_Period(j%) = iStep_Curr_Interval(j%)
                TxtPosition(j%).Text = lStep_Curr_Posn(j%)
            End If
        End If
        If (lStep_Target_Posn(j%) = lStep_Curr_Posn(j%)) Then iStep_Moving(j%) = False
    End If
  Next j%
  If gStepType <> K113 Then
    Call Write_Stepper
  Else
    Call Write_K113_Stepper
  End If
  Exit Sub
  
  

End Sub
