Attribute VB_Name = "Stepper"
Option Explicit
'Declare Inp and Out for port I/O
Declare Sub PortOut Lib "IO.DLL" (ByVal Port As Integer, ByVal Data As Byte)
Declare Sub PortWordOut Lib "IO.DLL" (ByVal Port As Integer, ByVal Data As Integer)
Declare Sub PortDWordOut Lib "IO.DLL" (ByVal Port As Integer, ByVal Data As Long)
Declare Function PortIn Lib "IO.DLL" (ByVal Port As Integer) As Byte
Declare Function PortWordIn Lib "IO.DLL" (ByVal Port As Integer) As Integer
Declare Function PortDWordIn Lib "IO.DLL" (ByVal Port As Integer) As Long
Declare Sub SetPortBit Lib "IO.DLL" (ByVal Port As Integer, ByVal Bit As Byte)
Declare Sub ClrPortBit Lib "IO.DLL" (ByVal Port As Integer, ByVal Bit As Byte)
Declare Sub NotPortBit Lib "IO.DLL" (ByVal Port As Integer, ByVal Bit As Byte)
Declare Function GetPortBit Lib "IO.DLL" (ByVal Port As Integer, ByVal Bit As Byte) As Boolean
Declare Function RightPortShift Lib "IO.DLL" (ByVal Port As Integer, ByVal Val As Boolean) As Boolean
Declare Function LeftPortShift Lib "IO.DLL" (ByVal Port As Integer, ByVal Val As Boolean) As Boolean
Declare Function IsDriverInstalled Lib "IO.DLL" () As Boolean




'Global Variables and Constants
Global Const NUM_IOV = 32

'Data Variables defining I/O
Global DAQNAME$
Global NUM_AIP As Integer
Global NUM_AOP As Integer
Global NUM_DIP As Integer
Global NUM_DOP As Integer

Global gSpeed&

Global DIPs(1 To 16) As Integer
Global DOPs(1 To 16) As Integer
Global AIPs(1 To NUM_IOV) As Single
Global AOPs(1 To NUM_IOV) As Integer
Global gDOP As Integer

'Printer Variables
Global LPTNo%, LptPortAddr%
Global LPTData%, LPTStatus%, LPTControl%
Global DataReg%, StatusReg%, ControlReg%, iErr%
Global gInputV%, gMeasureV%, gOffSetV%

Global gStepType As Integer
Global gFullHalf As Integer

Global Const TWO_PHASE_SEQ = 0
Global Const WAVE_SEQ = 1
Global Const HALF_STEP_SEQ = 2
Global Const K113 = 0
Global Const K158 = 1
Global Const K179 = 2



Function Inp(ByVal PortAddress As Integer) As Byte
Dim InpVal As Long
Dim bStatus As Boolean
    Inp = PortIn(PortAddress)
End Function
Sub Out(ByVal PortAddress As Integer, ByVal Value As Byte)
Dim bStatus As Boolean
Dim InpVal As Long
    Call PortOut(PortAddress, Value)
End Sub



Sub AWait(j&)
Dim i&
Dim K&
        'This procedure is a simple delay
        K& = 1
        For i& = 0 To j&
            K& = K& + 1
        Next i&
End Sub


Function FindPCSpeed()
Dim tv, tv1, Delay
Dim i&, j&
    'This routine finds the relative speed of the PC and
    'places it into the global variable gSpeed%
    'This variable is used in the timing to read and write
    'to the Stepper Board
    'This routine should be the first called
    
    j& = 1000
    Do
        j& = j& * 10
        tv = Timer
        For i& = 1 To j&
        Next i&
        tv1 = Timer
    Loop While (tv1 - tv) < 0.1
    'MsgBox "TV=" & Str(tv) & " TV1=" & Str(tv1)
    j& = 2 * j& / (tv1 - tv) 'Test will last approx two seconds
    tv = Timer
    For i& = 1 To j&
    Next i&
    tv1 = Timer
    Delay = j& / (tv1 - tv)
    If Delay > 500000 Then  'Each clk cycle for the ADC with be >4usec period
        gSpeed& = 0.000002 * Delay + 1
    Else
        gSpeed& = 1
    End If
    gSpeed& = gSpeed& * 3
    FindPCSpeed = Delay
End Function

Sub InitPrinterPort(LPTNo%, LPTPortAdd%)
' The function InitPrinterPort initialises the printer port used to control
' the DAQ.
' "LPTNo" is the number of the printer port 1 to 2
' "LPTPortAdd" if it is non zero the LPTNo is ignored and the value of
' LPTPortAdd is used as the base address
' If "LPTNo" is out of range "IErr%" is set to non-zero.
'
    iErr% = 0
    If LPTPortAdd% = 0 Then
        Select Case LPTNo%
            Case 1
                 LPTData% = &H378

            Case 2
                 LPTData% = &H278
            Case Else
                 iErr% = 1
        End Select
    Else
        LPTData% = LPTPortAdd%
    End If
    If iErr% = 0 Then
        LPTStatus% = LPTData% + 1
        LPTControl% = LPTData% + 2
        DataReg% = 0
        ControlReg% = &HA    '### was hfa Strobe and Init low Autofd high */
        Call Out(LPTControl%, ControlReg%)
    End If

End Sub


' The WriteAllDOP function sets or resets the four digital outputs
' according to the value of "DOValue%"
' DOValue% can have the values 0 to 15
' If the value of DOValue% is out of range
' "IErr%" is set to non-zero.
'
' Note the Function InitPrinterPort must be called at the
' start of the program before this function can be used
Sub WriteDOPs(DOValue%)
    iErr% = 0
    If iErr% = 0 Then
        DataReg% = DOValue%
        Call Out(LPTData%, DataReg%)
        ControlReg% = ControlReg% And &HFE       'bring strobe low then high */
        Call Out(LPTControl%, ControlReg%)
        ControlReg% = ControlReg% Or &H1
        Call Out(LPTControl%, ControlReg%)
    End If
End Sub

Sub WriteDOP(State%, IONum%)
' The WriteDOP function sets or resets a single output "IONum"
' according to the value in "State".
' IONum can have the values 1 to 4
' State can be 0 or 1.
' If the value of State or IONum are out of the above ranges
' "IErr%" is set to non-zero.
'
' Note the Function InitPrinterPort must be called at the
' start of the program before this function can be used
Dim Mask%, i%
    iErr% = 0
    If State% <> 0 And State% <> 1 Then
        iErr% = 1
    End If
    If IONum% < 1 Or IONum% > 4 Then
        iErr% = 1
    End If
    If iErr% = 0 Then
        Mask% = &H1
        For i% = 1 To IONum% - 1
            Mask% = Mask% * 2
        Next i%
        If State% = 0 Then
            Mask% = Not Mask%
            DataReg% = DataReg% And Mask%
        Else
            DataReg% = DataReg% Or Mask%
        End If
        Call Out(LPTData%, DataReg%)
        ControlReg% = ControlReg% And &HFE       'bring strobe low then high */
        Call Out(LPTControl%, ControlReg%)
        ControlReg% = ControlReg% Or &H1
        Call Out(LPTControl%, ControlReg%)
    End If

End Sub


