VERSION 5.00
Begin VB.Form PrinterAddr 
   Appearance      =   0  'Flat
   Caption         =   "Set Printer Port Address"
   ClientHeight    =   2925
   ClientLeft      =   2175
   ClientTop       =   2460
   ClientWidth     =   7560
   ControlBox      =   0   'False
   BeginProperty Font 
      Name            =   "MS Sans Serif"
      Size            =   8.25
      Charset         =   0
      Weight          =   700
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   ForeColor       =   &H80000008&
   HelpContextID   =   10
   LinkTopic       =   "Form1"
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   2925
   ScaleWidth      =   7560
   Begin VB.Frame Frame1 
      Caption         =   "Printer Port"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   2175
      Left            =   240
      TabIndex        =   6
      Top             =   360
      Width           =   3615
      Begin VB.TextBox Address 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Left            =   2280
         TabIndex        =   10
         Top             =   1440
         Width           =   975
      End
      Begin VB.OptionButton OptLpt 
         Caption         =   "Other Address Hex"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Index           =   2
         Left            =   240
         TabIndex        =   9
         Top             =   1440
         Width           =   2055
      End
      Begin VB.OptionButton OptLpt 
         Caption         =   "LPT 2 (278 Hex)"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Index           =   1
         Left            =   240
         TabIndex        =   8
         Top             =   960
         Width           =   1815
      End
      Begin VB.OptionButton OptLpt 
         Caption         =   "LPT 1 (378 Hex)"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Index           =   0
         Left            =   240
         TabIndex        =   7
         Top             =   480
         Width           =   1815
      End
   End
   Begin VB.CommandButton CmdFindPort 
      Caption         =   "&Find Port"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   5760
      TabIndex        =   5
      Top             =   1680
      Width           =   1095
   End
   Begin VB.CommandButton Exit 
      Caption         =   "E&xit"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   5760
      TabIndex        =   4
      Top             =   2280
      Width           =   1095
   End
   Begin VB.TextBox TxtMode 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   5520
      TabIndex        =   3
      Top             =   1080
      Width           =   1575
   End
   Begin VB.TextBox TxtTypePort 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   5520
      TabIndex        =   0
      Top             =   480
      Width           =   1575
   End
   Begin VB.Label Label2 
      Caption         =   "Mode"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   4560
      TabIndex        =   2
      Top             =   1080
      Width           =   975
   End
   Begin VB.Label Label1 
      Caption         =   "Type of Port"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   4560
      TabIndex        =   1
      Top             =   480
      Width           =   975
   End
End
Attribute VB_Name = "PrinterAddr"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Dim EcrAddress%, EcrData%
Dim PortBaseAddress%
Dim PortType$, PortMode$, PortCurrMode$


Private Sub CmdFindPort_Click()
Dim sStr$
Dim TP%
    If OptLpt(0).Value <> False Then
        LPTNo% = 1
        PortBaseAddress% = &H378
    End If
    If OptLpt(1).Value <> False Then
        LPTNo% = 2
        PortBaseAddress% = &H278
    End If
    If OptLpt(2).Value <> False Then
        LPTNo% = 0
        sStr$ = "&H" & Address.Text
        PortBaseAddress% = Val(sStr$)
    End If
    TP = TestPort(PortBaseAddress%)
    If TP = True Then
        TxtTypePort.Text = PortType$
        TxtMode.Text = PortMode$
    Else
        TxtTypePort.Text = "Not Found"
        TxtMode.Text = ""
    End If
    If PortType$ <> "" Then
        If PortType$ = "ECP" Then
            TxtMode.Text = "SPP"
            SetEcpMode (0) 'Set it to SPP
        End If
        Call InitPrinterPort(LPTNo%, LptPortAddr%)
        MsgBox "Printer Port Initialised"
    End If

End Sub

Private Sub CmdSPP_Click()
    If PortType$ <> "" Then
        If PortType$ = "ECP" Then
            TxtMode.Text = "SPP"
            SetEcpMode (0) 'Set it to SPP
        End If
        Call InitPrinterPort(LPTNo%, LptPortAddr%)
        MsgBox "Printer Port Initialised"
    End If
End Sub

Private Sub Exit_Click()
Dim sStr$
    LptPortAddr% = PortBaseAddress%
    Unload PrinterAddr
End Sub

Private Sub Form_Load()
    Left = (Screen.Width - Width) / 2
    Top = (Screen.Height - Height) / 2
    If LPTNo% = 1 Then
        OptLpt(0).Value = True
    End If
    If LPTNo% = 2 Then
        OptLpt(1).Value = True

    End If
    If LPTNo% = 0 Then
        OptLpt(2).Value = True
        Address.Text = Hex$(LptPortAddr%)
    End If
    TxtTypePort.Text = PortType$
    TxtMode.Text = PortMode$
 
End Sub

Function GetEcpModeDescription$(EcpModeValue%)
Select Case EcpModeValue
    Case 0
        GetEcpModeDescription = "SPP"
    Case 1
        GetEcpModeDescription = "PS/2"
    Case 2 '10
        GetEcpModeDescription = "Fast Centronics"
    Case 3 '11
        GetEcpModeDescription = "ECP"
    Case 4 '100
        GetEcpModeDescription = "EPP"
    Case 6 '110
        GetEcpModeDescription = "Test"
    Case 7 '111
        GetEcpModeDescription = "Configuration"
End Select
End Function


Function ReadEcpMode%(TestAddress%)
'The Ecr mode is in bits 5, 6, and 7 of the ECR.
EcrAddress = TestAddress + &H402
EcrData = Inp(EcrAddress)
ReadEcpMode = (EcrData And &HE0) \ &H20
End Function

Function ReadEppTimeoutBit%(PortBaseAddress%)
'Reads and clears the EPP timeout bit (status port bit 0).
'Should be done after each EPP operation.
'The method for clearing the bit varies, so try 3 ways:
'1. Write 1 to it.
'2. Write 0 to it.
'3. Read it again.
Dim StatusPortAddress%
Dim ReadAgain%
StatusPortAddress = PortBaseAddress + 1
ReadEppTimeoutBit = BitRead(StatusPortRead(PortBaseAddress), 0)
Out StatusPortAddress, 1
Out StatusPortAddress, 0
ReadAgain = BitRead(StatusPortRead(PortBaseAddress), 0)
End Function

Sub SetEcpMode(EcpModeValue%)
'Store the Ecp mode's value and description in the Port array.
'Port(IndexOfSelectedPort).EcpModeValue = EcpModeValue
'Port(IndexOfSelectedPort).EcpModeDescription = GetEcpModeDescription(EcpModeValue)
EcrAddress = PortBaseAddress + &H402
'Read the ECR & clear bits 5, 6, 7.
EcrData = Inp(EcrAddress) And &H1F
'Write the selected value to bits 5, 6, 7.
EcrData = EcrData + EcpModeValue * &H20
Out EcrAddress, EcrData
End Sub


Function TestForEcp%(TestAddress%)
'Test for the presence of an ECP.
'If the ECP is idle and the FIFO empty,
'in the ECP's Ecr (at Base Address+402h),
'bit 1(Fifo full)=0, and bit 0(Fifo empty)=1.
'The first test is to see if these bits differ from the
'corresponding bits in the control port (at Base Address+2).
'If so, a further test is to write 34h to the Ecr,
'then read it back. Bit 1 is read/write, and bit 0 is read-only.
'If the value read is 35h, the port is an ECP.
Dim EcrBit0%
Dim EcrBit1%
Dim ControlBit0%
Dim ControlBit1%
Dim ControlPortData%
Dim TestEcrAddress%
Dim OriginalEcrData%
TestForEcp = False
EcrAddress = TestAddress + &H402

'Read ECR bits 0 & 1 and Control Port bit 1.
EcrData = Inp(EcrAddress)
EcrData = 5
EcrBit0 = BitRead(EcrData, 0)
EcrBit1 = BitRead(EcrData, 1)
ControlPortData = ControlPortRead(TestAddress)
ControlBit1 = BitRead(ControlPortData, 1)
If EcrBit0 = 1 And EcrBit1 = 0 Then
    'Compare control bit 1 to ECR bit 1.
    'Toggle the control bit if necessary,
    'to be sure the two registers are different.
    If ControlBit1 = 0 Then
        ControlPortWrite TestAddress, &HF
        ControlPortData = ControlPortRead(TestAddress)
        ControlBit1 = BitRead(ControlPortData, 1)
    End If
    If EcrBit1 <> ControlBit1 Then
        OriginalEcrData = EcrData
        Out EcrAddress, &H34
        EcrData = Inp(EcrAddress)
        If EcrData = &H35 Then
            TestForEcp = True
        End If
        'Restore the ECR to its original value.
        Out EcrAddress, OriginalEcrData
    End If
End If
End Function

Function TestForEpp%(TestAddress%)
'Write to an Epp register, then read it back.
'If the reads match the writes, it's probably an Epp.
Dim ByteRead%
Dim StatusPortData%
Dim EppAddressPort%
Dim TimeoutBit%
Dim StatusPortAddress%
StatusPortAddress = TestAddress + 1
TestForEpp = False
'Use EppAddressPort for testing.
'SPPs, ECPs, and PS/2 ports don't have this register.
EppAddressPort = TestAddress + 3
Out EppAddressPort, &H55
'Clear the timeout bit after each EPP operation.
TimeoutBit = ReadEppTimeoutBit%(TestAddress%)
ByteRead = Inp(EppAddressPort)
TimeoutBit = ReadEppTimeoutBit%(TestAddress%)
If ByteRead = &H55 Then
    Out EppAddressPort, &HAA
    TimeoutBit = ReadEppTimeoutBit%(TestAddress%)
    ByteRead = Inp(EppAddressPort)
    TimeoutBit = ReadEppTimeoutBit%(TestAddress%)
    If ByteRead = &HAA Then
        TestForEpp = True
    End If
End If
End Function

Function TestForPS2%(TestAddress%)
'Tests a parallel port's data port for bidirectional ability.
'First, try to tri-state (disable) the data outputs by
'setting bit 5 of the Control port.
'Then write 2 values to the data port and read each back
'If the values match, the data outputs are not disabled,
'and the port is not bidirectional.
'If the values don't match,
'the data outputs are disabled and the port is bidirectional.
Dim DataInput%
Dim ControlPortData%
Dim OriginalControlPortData%
Dim OriginalDataPortData%

'Set Control port bit 5.
ControlPortWrite TestAddress, &H2F
TestForPS2 = False
'Write the first byte and read it back:
DataPortWrite TestAddress, &H55
DataInput = DataPortRead(TestAddress)
'If it doesn't match, the port is bidirectional.
If Not DataInput = &H55 Then TestForPS2 = True
'If it matches, write another and read it back.
If DataInput = &H55 Then
    DataPortWrite TestAddress, &HAA
    DataInput = DataPortRead(TestAddress)
    'If it doesn't match, the port is bidirectional
    If Not DataInput = &HAA Then
        TestForPS2 = True
    End If
End If
'Reset Control port bit 5
ControlPortWrite TestAddress, &HF
End Function

Function TestForSpp%(TestAddress%)
'Write two bytes and read them back.
'If the reads match the writes, the port exists.
Dim ByteRead%
'Be sure that control port bit 5 = 0 (data outputs enabled).
ControlPortWrite TestAddress, &HF
TestForSpp = False
DataPortWrite TestAddress, &H55
ByteRead = DataPortRead(TestAddress)
If ByteRead = &H55 Then
    DataPortWrite TestAddress, &HAA
    ByteRead = DataPortRead(TestAddress)
    If ByteRead = &HAA Then
        TestForSpp = True
    End If
End If
End Function

Function TestPort%(TestAddress%)
'Test for a port's presence, and if it exists, the type of port.
'In order, check for the presence of an ECP, EPP, SPP, and PS/2 port.
'Update the information in the Port array  and the display.
Dim EcpModeDescription$
Dim EcpModeValue%
Dim EcpExists%, EppExists%, SppExists, PS2Exists
TestPort = False
EcpExists = False
EppExists = False
SppExists = False
PS2Exists = False
PortType = ""
PortMode$ = ""
'TestAddress = Port(PortIndex).Address
'Begin by hiding all port details.
'frmSelectPort.lblAddress(PortIndex).Visible = False
'frmSelectPort.lblType(PortIndex).Visible = False
'frmSelectPort.cboEcpMode(PortIndex).Visible = False

EcpExists = TestForEcp(TestAddress)
If EcpExists Then
    PortType = "ECP"
    'Read the current Ecp mode.
    EcpModeValue = ReadEcpMode(TestAddress)
    PortMode$ = GetEcpModeDescription$(EcpModeValue%)
Else
    'If it's not an ECP, look for an EPP.
    'If TestAddress = 3BCh, skip the EPP test.
    'EPPs aren't allowed at 3BCh due to possible conflict
    'with video memory.
    'frmSelectPort.cboEcpMode(PortIndex).Visible = False
    If TestAddress = &H3BC Then
        EppExists = False
    Else
        EppExists = TestForEpp(TestAddress)
    End If
    If EppExists Then
        PortType = "EPP"
    Else
        'If it's not an EPP, look for an SPP.
        SppExists = TestForSpp(TestAddress)
        If SppExists Then
            'Test for a PS/2 port only if the SPP exists
            '(because if the port doesn't exist, it will pass the PS/2 test!)
            PS2Exists = TestForPS2(TestAddress)
            If PS2Exists Then
                PortType = "PS/2"
            Else
                PortType = "SPP"
            End If
        Else
            PortType = ""
        End If

    End If
End If

If PortType <> "" Then
    TestPort = True
End If
End Function


Function StatusPortRead%(PortBaseAddress%)
'Reads a parallel port's status port.
'Calculates the status-port address from the port's
'base address, and inverts bit 7 of the byte read.
'The status-port hardware reinverts these bits,
'so the value read matches the value at the connector.
StatusPortRead = (Inp(PortBaseAddress + 1) Xor &H80)
End Function

Function BitRead%(Variable%, BitNumber%)
'Returns the value (0 or 1) of the requested bit in a Variable.
Dim BitValue%
BitValue = 2 ^ BitNumber 'the value of the requested bit
BitRead = (Variable And BitValue) \ BitValue
End Function

Function ControlPortRead%(PortBaseAddress%)
'Reads a parallel port's control port.
'Calculates the control-port address from the port's
'base address, and inverts bits 0, 1, & 3 of the byte read.
'The control-port hardware reinverts these bits,
'so the value read matches the value at the connector.
ControlPortRead = (Inp(PortBaseAddress + 2) Xor &HB)
End Function

Sub ControlPortWrite(PortBaseAddress%, Value%)
'Writes a Value to a parallel port's control port.
'Calculates the control-port address from the port's
'base address, and inverts bits 0, 1, & 3.
'The control-port hardware reinverts these bits,
'so Value is written to the port connector.
Out PortBaseAddress + 2, Value Xor &HB
End Sub

Function DataPortRead%(PortBaseAddress%)
'Reads a parallel port's data port.
DataPortRead = Inp(PortBaseAddress)
End Function

Sub DataPortWrite(PortBaseAddress%, Value%)
'Writes a byte to a parallel port's data port.
Out PortBaseAddress, Value
End Sub

