                title    "flash"  ; Program title   June 2002
                
W     		equ     00H        	; Destination is W-Register
F      		equ     01H        	; Destination is F-Register
;
INDF	        equ     00H              
TMR0            equ     01H              
PCL             equ     02H              
STATUS          equ     03H              
FSR             equ     04H              
PORTA	        equ     05H             ;inputs 
PORTB	        equ     06H             ;outputs
PCLATH		equ	0AH
INTCON		equ	0BH		;gp files from 0Ch (68 files)
;
OPTION_REG	equ	081H
TRISA		equ	085H
TRISB		equ	086H
;
PERIOD		equ	0CH
HOLD		equ	0DH
SHIFT		equ	0EH
TEMP1		equ	0FH
TEMP2		equ	010H
STORE		equ	011H
TEMPLIM		equ	012H
MODFAC		equ	013H		
STORE2		equ	014H
WREG		equ	020H		;8 working regs
INDX		equ	030H		;array index (8locs)
;
INPUT		equ	PORTA					
OUTPUT		equ	PORTB
;	
;===========================================================================
;Subroutines
;===========================================================================
org 00H
		goto	main_start	;start of main program
		;
getmark		btfsc	input,4		;check which array	
		goto	otherone
		clrf	pclath
		movf	indf,W
		addwf	PCL, F
		retlw	01H	
		retlw	01H
		retlw	01H	
		retlw	01H	
		retlw	01H
		retlw	01H	
		retlw	01H	
		retlw	01H
		retlw	01H	
		retlw	01H	;10	
		retlw	01H
		retlw	01H	
		retlw	01H	
		retlw	01H	
		retlw	01H
		retlw	01H	
		retlw	01H
		retlw	01H	
		retlw	01H	
		retlw	01H	;20
		retlw	01H	
		retlw	01H	
		retlw	01H	
		retlw	01H
		retlw	01H	
		retlw	01H	
		retlw	01H
		retlw	01H	
		retlw	01H
		retlw	01H	;30
		retlw	01H
		retlw	01H	
		retlw	01H	
		retlw	01H
		retlw	01H	
		retlw	02H		
		retlw	02H
		retlw	02H	
		retlw	02H
		retlw	02H	;40
		retlw	03H
		retlw	03H	
		retlw	03H	
		retlw	03H
		retlw	04H	
		retlw	04H	
		retlw	04H
		retlw	05H
		retlw	05H	
		retlw	06H	;50
		retlw	06H
		retlw	07H	;
		retlw	07H
		retlw	08H
		retlw	08H
		retlw	09H
		retlw	09H
		retlw	0AH	
		retlw	0AH
		retlw	0BH	;60
		retlw	0BH
		retlw	0CH	;
		retlw	0CH
		retlw	0DH
		retlw	0DH
		retlw	0EH
		retlw	0EH
		retlw	0FH	
		retlw	0FH
		retlw	010H	;70
		retlw	011H
		retlw	012H	;
		retlw	013H
		retlw	014H
		retlw	016H
		retlw	018H
		retlw	01AH
		retlw	01CH	
		retlw	01EH
		retlw	020H	;80
		retlw	024H
		retlw	028H	;
		retlw	02CH
		retlw	030H
		retlw	038H
		retlw	040H	
		retlw	048H	
		retlw	050H	
		retlw	058H
		retlw	060H	;90
		retlw	068H
		retlw	070H	
		retlw	080H	
		retlw	090H
		retlw	0A0H	
		retlw	0B0H
		retlw	0C0H	
		retlw	0D0H
		retlw	0F0H
		retlw	0FFH	;100
		retlw	0F0H
		retlw	0D0H	
		retlw	0C0H	
		retlw	0B0H
		retlw	0A0H	
		retlw	090H
		retlw	080H
		retlw	070H	
		retlw	068H
		retlw	060H	;110	
		retlw	058H
		retlw	050H	
		retlw	048H
		retlw	040H	
		retlw	038H
		retlw	030H
		retlw	02CH
		retlw	028H	
		retlw	024H	
		retlw	020H	;120
		retlw	01EH
		retlw	01CH
		retlw	01AH
		retlw	018H	
		retlw	016H
		retlw	014H
		retlw	013H
		retlw	012H	
		retlw	011H
		retlw	010H	;130
		retlw	0FH
		retlw	0FH
		retlw	0EH
		retlw	0EH
		retlw	0DH
		retlw	0DH	
		retlw	0CH
		retlw	0CH	
		retlw	0BH	
		retlw	0BH	;140
		retlw	0AH
		retlw	0AH	
		retlw	09H
		retlw	09H
		retlw	08H
		retlw	08H	
		retlw	07H
		retlw	07H	
		retlw	06H
		retlw	06H	;150
		retlw	05H
		retlw	05H	
		retlw	04H
		retlw	04H
		retlw	04H	
		retlw	03H	
		retlw	03H
		retlw	03H	
		retlw	03H	
		retlw	02H	;160	
		retlw	02H
		retlw	02H	
		retlw	02H
		retlw	02H	
		retlw	01H
		retlw	01H	
		retlw	01H
		retlw	01H	
		retlw	01H
		retlw	01H	;170	
		retlw	01H	
		retlw	01H	
		retlw	01H	
		retlw	01H	
		retlw	01H
		retlw	01H	
		retlw	01H	
		retlw	01H		
		retlw	01H
		retlw	01H	;180	
		retlw	01H	
		retlw	01H	
		retlw	01H	
		retlw	01H	
		retlw	01H	
		retlw	01H
		retlw	01H	
		retlw	01H	
		retlw	01H
		retlw	01H	;190	
		retlw	01H	
		retlw	01H	
		retlw	01H	
		retlw	01H	
		retlw	01H
		retlw	01H	
		retlw	01H	
		retlw	01H	
		retlw	01H	
		retlw	01H	;200
		retlw	01H	
		retlw	01H	
		retlw	01H
		retlw	01H	
			;
getlim		clrf	pclath		;get index limit and modify
		call	lim		;according to modfac.This gives
		movwf	store		;the number of /2's
		movf	modfac,W	;div factor (+1)
		movwf	store2
		bcf	status,0	;clear carry
		rlf	store,F		;limit *2
divlim		rrf	store,F		;index lim /2
		decfsz	store2,F	;this determines the no of div by 2's
		goto	divlim
		movf	store,W		;modified index limit
		movwf	templim		;save for lower limit
		addlw	D'100'
		return
		;
lim		addwf	PCL, F		;index limits
		retlw	D'76'
		retlw	D'80'
		retlw	D'84'
		retlw	D'88'
		retlw	D'92'
		retlw	D'96'
		retlw	D'100'
		retlw	D'72'	
		;
resetlim	movf	templim,W	
		sublw	D'99'		;w = 100 - lim	
		movwf	indf
		return			;with start value in W
		;
speed		clrf	pclath
		addwf	PCL,F
		retlw	01H	;for 00 switch setting, port a b0,b1
		retlw	04H	;    10
		retlw	02H	;    01
		retlw	08H	;    11	
		;
getmod		clrf	pclath
		addwf	PCL,F
		retlw	08H
		retlw	010H
		retlw	018H
		retlw	020H							
org	0100H
;=================================================================
;Main programme
;=================================================================
main_start	clrf	output
		clrf	input
		bsf	status, 5
		clrf	TRISB		;set port b to o/p
		movlw	0FFH
		movwf	TRISA		;set port a to i/p
		movlw	080H
		movwf	option_reg
		bcf	status, 5
		;
		movlw	08H		;set all array indexes to 0
		movwf	temp2
		movlw	indx
		movwf	FSR
clearindx	clrf	indf
		incf	FSR,F
		decfsz	temp2,F
		goto	clearindx		
		;
outer		movlw	03H		;read speed switches
		andwf	input,W		;mask off other switches
		call	speed		;repititions of mark/space
		movwf	hold		;for each array value
		btfsc	input,4
		incf	hold,F
		;
		movlw	B'00001100'	;get modulation factor
		andwf	input,W
		movwf	modfac
		bcf	status,0	;clear carry
		rrf	modfac,F
		rrf	modfac,F	;shift mod to ls bits
		movf	modfac,W
		addwf	hold,F		;modify speed if <100% mod 
		incf	modfac,F	;1=/1div, 2=/2, etc
;--------------------------------------------------------------------------		
;Put array values into working regs
opmark		movlw	01H		;counter for 8 values
		movwf	shift
		movlw	wreg		;working reg
		movwf	temp1		;save address
		movlw	indx		;index
		movwf	temp2		;save address
loadmark	movf	temp2, W	;index addr
		movwf	FSR
		call	getmark		;get mark from array
		movwf	store
		movf	temp1, W	;addr for wreg
		movwf	FSR
		movf	store, W
		movwf	indf
		incf	temp1, F	;next working reg
		incf	temp2, F	;next array index
		rlf	shift, F	;b7 into carry ?
		btfss	status, 0	;temp1,2 set to 9th loc on exit
		goto	loadmark	;but lost anyway
					;exit with c=1
;--------------------------------------------------------------------------
;Output one mark/space for all 8 outputs
		movlw	0FFH		;inner loop. Mark is already
		movwf	period		;loaded into work reg
domark		movlw	wreg		;space is 255-mark
		movwf	FSR		;base address
		movlw	01H		;keeps track of 8 working regs
		movwf	shift		;and use to set/clear o/p bits
		bcf	status,0	;clear carry	
opbits		decfsz	indf, F		;decrement mark
		goto 	setbit		;if >0
		comf	shift, W	;space if 0
		andwf	output, F	;set output pin lo
		incf	indf, F		;restore to 1 for next loop
		goto	nextbit
setbit		movf	shift, W
		iorwf	output, F	;set pin hi
nextbit		incf	FSR, F		;next working reg
		rlf	shift, F	;working reg tracker
		btfss	status, 0	;all 8 wregs done if c=1
		goto	opbits		;care! 9th indirect reg has been 
					;incremented
		decfsz	period, F
		goto	domark
					;exit with c=1
;--------------------------------------------------------------------------		
;Repeat to control speed
		decfsz	hold, F		;repeat mark/space o/p 
		goto	opmark		;to control speed 
;--------------------------------------------------------------------------		
;Check the size of indexes
		movlw	01H		;check if indexes have reached
		movwf	shift		;their limits
		clrf	temp1		;no. of index, 0-7
		movlw	indx		;index base address
		movwf	FSR
indlim		movf	temp1, W	;offset
		call	getlim		;limit for this offset
		subwf	indf, W		;W = indf-W
		btfsc	status, 0	;c=1 for 0 or +ve result
		call	resetlim	;i.e. limit reached
		incf	indf, F		;increment current index
		incf	temp1, F	;o/s for next limit
		incf	FSR, F		;next array index
		rlf	shift, F	;8 indexes done ?
		btfss	status,0		
		goto	indlim		;exit with c=1
		;indx value set to 1 if cleared
		goto	outer		;next mark/space
		;
;-----------------------------------------------------------------------------
org	0200H
otherone	movlw	02H
		movwf	pclath
		movf	indf,W
		addwf	PCL, F
		retlw	01H	
		retlw	01H
		retlw	01H	
		retlw	01H	
		retlw	01H
		retlw	01H	
		retlw	01H	
		retlw	01H
		retlw	01H	
		retlw	01H	;10	
		retlw	01H
		retlw	01H	
		retlw	01H	
		retlw	01H	
		retlw	01H
		retlw	01H	
		retlw	01H
		retlw	01H	
		retlw	01H	
		retlw	01H	;20
		retlw	01H	
		retlw	01H	
		retlw	01H	
		retlw	01H
		retlw	01H	
		retlw	01H	
		retlw	01H
		retlw	01H	
		retlw	01H
		retlw	01H	;30
		retlw	01H
		retlw	01H	
		retlw	01H	
		retlw	01H
		retlw	01H	
		retlw	01H		
		retlw	01H
		retlw	01H	
		retlw	01H
		retlw	01H	;40
		retlw	01H
		retlw	01H	
		retlw	01H	
		retlw	02H
		retlw	02H	
		retlw	01H	
		retlw	01H
		retlw	03H
		retlw	03H	
		retlw	01H	;50
		retlw	01H
		retlw	04H	
		retlw	06H
		retlw	01H
		retlw	01H
		retlw	08H
		retlw	0AH
		retlw	01H	
		retlw	01H
		retlw	0EH	;60
		retlw	010H
		retlw	01H	
		retlw	01H
		retlw	012H
		retlw	014H
		retlw	01H
		retlw	01H
		retlw	016H	
		retlw	018H
		retlw	01H	;70
		retlw	01H
		retlw	01AH	
		retlw	01CH
		retlw	01H
		retlw	01H
		retlw	020H
		retlw	024H
		retlw	01H	
		retlw	01H
		retlw	028H	;80
		retlw	030H
		retlw	01H	
		retlw	01H
		retlw	038H
		retlw	040H
		retlw	01H	
		retlw	01H	
		retlw	060H	
		retlw	080H
		retlw	01H	;90
		retlw	01H
		retlw	0A0H	
		retlw	0C0H	
		retlw	01H
		retlw	01H	
		retlw	0D0H
		retlw	0E0H	
		retlw	01H
		retlw	01H
		retlw	0FFH	;100
		retlw	0FFH
		retlw	01H	
		retlw	01H	
		retlw	0E0H
		retlw	0D0H	
		retlw	01H
		retlw	01H
		retlw	0C0H	
		retlw	0A0H
		retlw	01H	;110	
		retlw	01H
		retlw	080H	
		retlw	060H
		retlw	01H	
		retlw	01H
		retlw	040H
		retlw	038H
		retlw	01H	
		retlw	01H	
		retlw	030H	;120
		retlw	028H
		retlw	01H
		retlw	01H
		retlw	024H	
		retlw	020H
		retlw	01H
		retlw	01H
		retlw	01CH	
		retlw	01AH
		retlw	01H	;130
		retlw	01H
		retlw	018H
		retlw	014H
		retlw	01H	
		retlw	01H
		retlw	012H	
		retlw	010H	
		retlw	01H	
		retlw	01H
		retlw	0EH	;140	
		retlw	0CH
		retlw	01H
		retlw	01H
		retlw	0AH	
		retlw	08H
		retlw	01H	
		retlw	01H
		retlw	06H	
		retlw	04H
		retlw	01H	;150	
		retlw	01H
		retlw	03H
		retlw	03H	
		retlw	01H	
		retlw	01H
		retlw	02H	
		retlw	02H	
		retlw	01H	
		retlw	01H
		retlw	01H	;160
		retlw	01H
		retlw	01H	
		retlw	01H
		retlw	01H	
		retlw	01H
		retlw	01H	
		retlw	01H
		retlw	01H	
		retlw	01H	
		retlw	01H	;170
		retlw	01H	
		retlw	01H	
		retlw	01H
		retlw	01H	
		retlw	01H	
		retlw	01H	
		retlw	01H
		retlw	01H	
		retlw	01H	
		retlw	01H	;180
		retlw	01H	
		retlw	01H	
		retlw	01H	
		retlw	01H
		retlw	01H	
		retlw	01H	
		retlw	01H
		retlw	01H	
		retlw	01H	
		retlw	01H	;190
		retlw	01H	
		retlw	01H	
		retlw	01H
		retlw	01H	
		retlw	01H	
		retlw	01H	
		retlw	01H	
		retlw	01H
		retlw	01H	
		retlw	01H	;200	
		retlw	01H
		retlw	01H			
         	end
