{==================================================================
 Pascal Routines for the DAS005 Data Acquisition System
 Author Peter Simmonds
 Date   4th September 1996
 Company  Ocean Controls
 ==================================================================}

PROGRAM  SampleProgram;

Uses
    Crt,
    Dos;


const
      TIMEDELAY=200;

var
 i,j,jl,k,Err :INTEGER; {These variables are used by the sample program}
 rnum:REAL;
 LPTData,LPTStatus,LPTControl :INTEGER; {These variables are global and used by functions}
 DataReg,StatusReg,ControlReg :BYTE;
 gSpeed :INTEGER;
 gain,offset :REAL;

{===================================================================}
PROCEDURE Wait(j:INTEGER);
var
    i,k :INTEGER;
BEGIN
    for i:=1 to j do k:=k+1;
END;



{ ===================================================================
 The ReadADC function reads the MAX186 ADC
 If ChanMode=0 then it is a differential reading and
    Channel can be 1 to 4.
      Channel 1=ADC inputs 1 & 2
      Channel 2=ADC inputs 3 & 4
      Channel 3=ADC inputs 5 & 6
      Channel 4=ADC inputs 7 & 8
 If ChanMode=1 then it is a single ended reading and
    Channel can be 1 to 8 where the ADC input is the same as the
    Channel number.
 If ChanMode or Channel is outside the range function returns a -1
}
FUNCTION ReadADC(ChanMode,Channel : INTEGER) :INTEGER;
var
    i,Word,Mask,err :INTEGER;
    Bit :BYTE;
BEGIN
    err:=0;
    ControlReg:=ControlReg and 253;  { Hex fd }
    Port[LPTControl]:=ControlReg;     { CS High }
    Port[LPTData]:=0;        { SCLK Low, DIN Low }
    case ChanMode of
        1 : if (( Channel<0) OR (Channel>8)) then err:=-1;
        0 : if((Channel<0) OR (Channel>4)) then err:=-1;
        else
          err:=-1;
    end;
    if err=0 then
    BEGIN
        Channel:=Channel-1;
        Word:=0;
        if (ChanMode=1) then { Single Ended }
           BEGIN
           if (Channel AND 1)<>0 then Word:=Word OR 4;
           if (Channel AND 2)<>0 then Word:=Word OR 1;
           if (Channel AND 4)<>0 then Word:=Word OR 2;
           END
        else Word:=Channel;
        Word:=Word SHL 4;
        ChanMode:=ChanMode SHL 2;
        Word:=Word OR ChanMode;
        Word:=Word OR 138;

        ControlReg:=ControlReg or 2;
        Port[LPTData]:=0;       { SCLK Low, DIN Low }
        Port[LPTControl]:=ControlReg;     { Bring CS Low }
        Mask:=128;
        for i:=1 to 8 do          { send the control word }
            BEGIN
            Bit:=Word and Mask;
            if(Bit<>0) then
                BEGIN
                Port[LPTData]:=2;   { CS Low SCLK Low, DIN High }
                Wait(gSpeed);
                Port[LPTData]:=3;   { CS Low SCLK High, DIN High }
                Wait(gSpeed);
                END
            else
                BEGIN
                Port[LPTData]:=0;    { CS Low SCLK Low, DIN Low }
                Wait(gSpeed);   { CS Low SCLK High, DIN Low }
                Port[LPTData]:=1;   { CS Low SCLK High, DIN High }
                Wait(gSpeed);
                END;
            Mask:=Mask SHR 1;
            END;
        Port[LPTData]:=0;    { CS Low SCLK Low, DIN Low }
        Wait(20*gSpeed);   { The ADC does its conversion here }
        Word:=0;           { Now get the reading }
        for i:=1 to 12 do
            BEGIN
            Word:=Word SHL 1;
            Port[LPTData]:=1;   { Bring Clk High }
            Wait(gSpeed);
            Port[LPTData]:=0;    { Bring Clk Low }
            Wait(gSpeed);
            Bit:=Port[LPTStatus];        { read ADC's Data Out }
            Bit := Bit and 8;
            if(Bit<>0) then Word:=Word or 1;
            END;
        ControlReg:=ControlReg and 253;  { Hex fd }
        Port[LPTControl]:=ControlReg;         { Bring CS High }
        END;
    if err=0 then ReadADC:=Word;
    if err=-1 then ReadADC:=-1;
END;

{ ===================================================================
  A routine to determine the speed of the PC so that delays can be
  calculated for reading the ADC
}
PROCEDURE mSecDelay(iS : Word);
var
j,k,l:WORD;
   BEGIN
   for j:=1 to iS do
       BEGIN
       for l:=1 to 1000 do
           BEGIN
           k:=0;
           while k<gSpeed do
              BEGIN
                  k:=k+1
              END
           END
       END
END;

{ ===================================================================
  A routine to determine the speed of the PC so that delays can be
  calculated for reading the ADC
}
PROCEDURE FindPCSpeed;
var
  iStart,iEnd:LONGINT;
  Hrs,Mins,Secs,HSecs:WORD;
  rdiff,timedelay: REAL;
  i,j,k:LONGINT;
BEGIN
    j:=100000;
    rdiff:=0;
    while (rdiff<0.2) do
        BEGIN
            GetTime(Hrs,Mins,Secs,HSecs);
            iStart:=Secs*100+HSecs;
            for i:=0 to j do k:=k+1;
            GetTime(Hrs,Mins,Secs,HSecs);
            iEnd:=Secs*100+HSecs;
            if (iEnd>=iStart) then
               BEGIN
               rdiff:=iEnd-iStart;
               END
            else
                BEGIN
                rdiff:=iEnd-iStart;
                END;
            rdiff:=rdiff/100;
            if (rdiff<0.2) then j:=j*10;
       END;  {end while}
    k:=Round(2.0/rdiff); { Determine the number of counts to do in 2 seconds }
    j:=j*k;
    k:=0;
    GetTime(Hrs,Mins,Secs,HSecs); { Get the start time }
    iStart:=Secs*100+HSecs;
    for i:=0 to j do k:=k+1;      { Do the counting }
    GetTime(Hrs,Mins,Secs,HSecs); { Get the end time }
    iEnd:=Secs*100+HSecs;
    if (iEnd>=iStart) then
       BEGIN
       rdiff:=iEnd-iStart;
       END
    else
       BEGIN
       rdiff:=iEnd-iStart;
       END;
    rdiff:=rdiff/100;             { Get the time elapsed in secs }
    timedelay:=rdiff/i;
    if (timedelay<0.000002) then   { if the timedelay is under 2uSecs get a value for gSpeed }
       BEGIN
       gSpeed:=Round(0.000002/timedelay+1);
       END
    else gSpeed:=1;   { otherwise let gSpeed = 1}
    Writeln;
    Writeln('PCs timedelay=',timedelay,'uSec gspeed=',gSpeed);
    mSecDelay(2000);
END;

{===================================================================}
{ The ReadAllDips function reads the four digital inputs 1-4
 * and returns then as an integer with a value of 0 to 15
 * depending on the state of the inputs
 }
FUNCTION ReadAllDips:INTEGER;
var
    i,ip :BYTE;
BEGIN
    Port[LPTData]:=DataReg; { Make sure Digital Outputs don't change }
    Wait(gSpeed*10);
    ControlReg :=ControlReg and 254;   { Hex FE bring strobe low then high to latch the inputs }
    Port[LPTControl]:=ControlReg;
    Wait(gSpeed*10);
    ControlReg := ControlReg or 1;
    Port[LPTControl]:=ControlReg;
    Wait(gSpeed*10);
    i:=Port[LPTStatus];
    ip:=i xor 128;  { invert the busy signal }
    ip:=ip and 240;
    ip:=ip SHR 4;
    ReadAllDips:=ip;
END;

{===================================================================}
{ The ReadDip function reads the state of a single digital input
 * The number of the input is in "IONum" and can have a value of 1 to 4
 * If IONum is not in the range of 1 to 4 then -1 is returned
 }
FUNCTION ReadDIP(IONum:INTEGER):INTEGER;
var
    i,ip,Mask :BYTE;
    Bit,err :INTEGER;
BEGIN
    err:=0;
    if(IONum<1) OR (IONum>4) then err:=-1;
    if(err=0) then
        BEGIN
		Port[LPTData]:=DataReg; { Make sure Digital Outputs don't change }
        Wait(gSpeed*10);
        ControlReg := ControlReg and 254;   { bring strobe low then high to latch the inputs }
		Port[LPTControl]:=ControlReg;
        Wait(gSpeed*10);
        ControlReg := ControlReg or 1;
		Port[LPTControl]:=ControlReg;
        Wait(gSpeed*10);
		i:=Port[LPTStatus];
        ip:=i xor 128;  { invert the busy signal }
        ip:=ip and 240; {Hex F0}
        Mask:=8;
		Mask:=Mask SHL IONum;
        ip:=ip and Mask;
        Bit:=0;
        if(ip<>0) then Bit:=1;
        END;
    if err=0 then ReadDIP:=Bit;
    if err=-1 then ReadDip:=-1;
END;

{===================================================================}
{ The WriteDOP function sets or resets a single output "IONum"
 * according to the value in "State".
 * IONum can have the values 1 to 4
 * State can be 0 or 1.
 * If the value of State or IONum are out of the above ranges
 * "err" is set to -1.
 }
PROCEDURE WriteDOP(State,IONum:INTEGER);
var
    Mask :BYTE;
    err: INTEGER;
BEGIN
    err:=0;
	if(State<>0) AND (State<>1) then err:=-1;
	if(IONum<1) OR (IONum>4) then err:=-1;
	IONum:=IONum-1;
	if(err=0) then
        BEGIN
        Mask:=1;
		Mask:=Mask SHL IONum;
        if(State=0) then
            BEGIN
            Mask:=Mask xor 255;
            DataReg:=DataReg and Mask;
            END
        else DataReg:=DataReg or Mask;
        Port[LPTData]:=DataReg;
        Wait(gSpeed*10);
        ControlReg := ControlReg and 254;   { Hex FE bring strobe low then high }
        Port[LPTControl]:=ControlReg;
        Wait(gSpeed*10);
        ControlReg :=ControlReg or 1;
        Port[LPTControl]:=ControlReg;
        Wait(gSpeed*10);
    END
END;

{===================================================================}
{ The WriteAllDOP function sets or resets the four digital outputs
 * according to the value of "DOValue"
 * DOValue can have the values 0 to 15
 * If the value of DOValue is out of range
 * "err" is set to -1.
 }
PROCEDURE WriteAllDOP(DOValue:INTEGER);
var
   err:INTEGER;

BEGIN
  err:=0;
  if(DOValue<0) or (DOValue>15) then err:=-1;
  if(err=0) then
    BEGIN
    DataReg:=DOValue;
	Port[LPTData]:=DataReg;
    ControlReg := ControlReg and 254;   { Hex FE bring strobe low then high }
	Port[LPTControl]:=ControlReg;
    Wait(gSpeed*10);
    ControlReg := ControlReg or 1;
	Port[LPTControl]:=ControlReg;
    Wait(gSpeed*10);
    END
END;

{===================================================================}
{ The function InitPrinterPort initialises the printer port used to control
 * the DAS005.
 * "LPTNo" is the number of the printer port 1 to 3
 * "LPTPortAdd" if it is non zero the LPTNo is ignored and the value of
 * LPTPortAdd is used as the base address
 * If "LPTNo" is out of range "err" is set to -1.
 }
PROCEDURE InitPrinterPort(LPTNo, LPTPortAdd:INTEGER);
var
   err:INTEGER;
BEGIN
  err:=0;
  if(LPTPortAdd=0) then
    BEGIN
        CASE LPTNo OF
            1 : LPTData:=888; {Hex Address 378 }

            2 : LPTData:=632; {Hex Address 278 }
        ELSE
            err:=-1;
        END
    END
    else LPTData:=LPTPortAdd;
    if(err=0) then
        BEGIN
        LPTStatus:=LPTData+1;
        LPTControl:=LPTData+2;
        DataReg:=0;
        WriteAllDOP(0);
        ControlReg:=11;         {Hex 11 Strobe low Autofd high }
        Port[LPTControl]:=ControlReg;
        END
END;

BEGIN
    clrscr;
    Writeln('Calculating Speed of PC');
    FindPCSpeed;
    gain:=1;  { the gain and offset can be edited to provide more accurate readings }
    offset:=0;
    InitPrinterPort(1,0);
    for k:=1 to 2000 do
        BEGIN
        clrscr;
        Writeln('***** Read Single Ended ADC Channels *****');
        for i := 1 to 8 do   {Testing the MAX186 ADC}
            BEGIN
            j:= ReadADC(1, i);
            rnum:=j;
            j:=Round(rnum*gain+offset);
            Writeln('ADC ',i,'=',j);
            END;
        Writeln('***** Read Differential ADC Channels *****');
        for i := 1 to 4 do
            BEGIN
            j := ReadADC(1, i*2-1);
            rnum:=j;
            j:=Round(rnum*gain+offset);
            jl:=ReadADC(1,i*2);
            rnum:=jl;
            jl:=Round(rnum*gain+offset);
            Writeln('ADC ',i,'=', j-jl);
       END;
       { Reading all the DIPS }
       writeln('***** Read All DIPs ******');
       i := ReadAllDips;
       Write('Reading all DIPs=', i);

       { Reading each of the Single DIPs }
       writeln('***** Read Each DIPs ******');
       for i := 1 to 4 do
           BEGIN
           j := ReadDIP(i);
           Writeln('DIP ',i,'=',j);
           END;

       { Writing Single DOPs }
       Writeln('***** Writing Single DOPs *****');
       for i := 1 to 4 do
           BEGIN
           WriteDOP(1, i); { turn the digital output on }
           mSecDelay(TIMEDELAY);
           WriteDOP(0, i); { turn the digital input off }
           mSecDelay(TIMEDELAY);
           END;

       { Write to all the DOPs }
       Writeln('***** Writing to All DOPS *****');
       WriteAllDOP(15);
       Writeln('Turn all DOPs On');
       mSecDelay(1000);
       WriteAllDOP(0);
       Writeln('Turn all DOPs Off');
       mSecDelay(1000);
       END
END.
