DECLARE SUB LongDelay ()
DECLARE FUNCTION ReadADC (ChanMode%, Channel%)
DECLARE SUB InitPrinterPort (LPTNo%, LPTPortAdd%)
DECLARE SUB FindPCSpeed ()
DECLARE FUNCTION ReadDIP (IONUM%)
DECLARE FUNCTION ReadAllDips ()
DECLARE SUB WriteDop (State%, IONUM%)
DECLARE SUB WriteAllDOP (DOValue%)
DECLARE SUB AWait (J%)

COMMON SHARED LPTData%, LPTStatus%, LPTControl%
COMMON SHARED DataReg%, StatusReg%, ControlReg%, IErr%
COMMON SHARED gSpeed%
COMMON SHARED NL

'MAIN PART OF THE PROGRAM BEGINS HERE
CALL InitPrinterPort(1, 0)
CALL FindPCSpeed
CALL LongDelay
CLS
'The Gain and Offset can be edited to provide more accurate readings
Gain = 1
Offset = 0

FOR k% = 1 TO 20
	CLS
	PRINT "***** Read Single Ended ADC Channels *****"
	FOR i% = 1 TO 8 'Testing the MAX186 ADC
		l% = i%
		J% = ReadADC(1, l%)
		J% = J% * Gain + Offset
		PRINT "ADC "; i%; "="; J%; "mV"
	NEXT i%
	PRINT "***** Read Differential ADC Channels *****"
	FOR i% = 1 TO 4 'Testing the MAX186 ADC
		J% = ReadADC(1, i% * 2 - 1)
		J% = J% * Gain + Offset
		JL% = ReadADC(1, i% * 2)
		JL% = JL% * Gain + Offset
		PRINT "ADC "; i%; "="; J% - JL%; "mV"
	NEXT i%

	'Read All the DIPs
	i% = ReadAllDips
	PRINT "***** Read All DIPs *****"
	PRINT "DIPs="; i%

	'Reading Single DIPs
	PRINT "***** Reading each DIP *****"
	FOR i% = 1 TO 4
		J% = ReadDIP(i%)
		PRINT "DIP "; i%; "="; J%; "  ";
	NEXT i%
      
	'Writing Single DOPs
	PRINT "***** Writing to Each DOP *****"
	FOR i% = 1 TO 4
		CALL WriteDop(1, i%)'turn it on
	    CALL LongDelay
	    CALL WriteDop(0, i%)'turn it off
	    CALL LongDelay
	NEXT i%
       
	'Write to all the DOPs
	PRINT "***** Writing to All DOPs *****"
	CALL WriteAllDOP(15)
	PRINT "Turn all DOPs On  ";
	CALL LongDelay
	CALL WriteAllDOP(0)
	PRINT "Turn all DOPs Off"
	CALL LongDelay
NEXT k%
END

SUB AWait (J%)
		k% = 1
		FOR i% = 0 TO J%
			k% = k% + 1
		NEXT i%
END SUB

'===================================================================*/
' A routine to determine the speed of the PC so that delays can be
' calculated for reading the ADC
SUB FindPCSpeed
	J = 10000
	DO
		start = TIMER
		FOR NL = 0 TO J
		NEXT NL
		endt = TIMER
		Diff = endt - start
		IF Diff < .2 THEN J = J * 10
	LOOP WHILE Diff < .2
	J = J * 2 / Diff
	start = TIMER
	FOR NL = 0 TO J
	NEXT NL
	endt = TIMER
	timedelay = (endt - start) / NL
	IF (timedelay < .000002) THEN
		gSpeed = .000002 / timedelay + 1
	ELSE
		gSpeed = 1
	END IF
	PRINT " PC's timedelay="; timedelay; "uSec gSpeed="; gSpeed
END SUB

' The function InitPrinterPort initialises the printer port used to control
' the DAS005.
' "LPTNo" is the number of the printer port 1 to 3
' "LPTPortAdd" if it is non zero the LPTNo is ignored and the value of
' LPTPortAdd is used as the base address
' If "LPTNo" is out of range "IErr%" is set to non-zero.
'
SUB InitPrinterPort (LPTNo%, LPTPortAdd%)
	IErr% = 0
	IF LPTPortAdd% = 0 THEN
		SELECT CASE LPTNo%
			CASE 1
				 LPTData% = &H378

			CASE 2
				 LPTData% = &H278
			CASE ELSE
				 IErr% = 1
		END SELECT
	ELSE
		LPTData% = LPTPortAdd%
	END IF
	IF IErr% = 0 THEN
		LPTStatus% = LPTData% + 1
		LPTControl% = LPTData% + 2
		DataReg% = 0
		WriteAllDOP (0)
		ControlReg% = &HB                                'Strobe low Autofd high */
		OUT LPTControl%, ControlReg%
	END IF
END SUB

SUB LongDelay
	FOR i% = 1 TO 2500
		fx = 1.234 * 9.345 / 123.45
	NEXT i%
END SUB

' The ReadADC function reads the MAX186 ADC
' If ChanMode=0 then it is a differential reading and
'    Channel can be 1 to 4.
'       Channel 1=ADC inputs 1 & 2
'       Channel 2=ADC inputs 3 & 4
'       Channel 3=ADC inputs 5 & 6
'       Channel 4=ADC inputs 7 & 8
' If ChanMode=1 then it is a single ended reading and
'       Channel can be 1 to 8 where the ADC input is the same as the
'       Channel number.
' If ChanMode or Channel is outside these ranges IErr% is returned as
'    a non zero value.
FUNCTION ReadADC (ChanMode%, Chan%)
	IErr% = 0
	Channel% = Chan%
	OUT LPTData%, &H0                               'SCLK Low, DIN Low */
	ControlReg% = ControlReg% AND &HFD      'Bring CS High
	OUT LPTControl%, ControlReg%    'CS High
	SELECT CASE ChanMode%
		CASE 1
			IF Channel% < 0 OR Channel% > 8 THEN
				IErr% = 1
			END IF
		CASE 0
			IF Channel% < 0 OR Channel% > 4 THEN
				IErr% = 1
			END IF
		CASE ELSE
			IErr% = 1
	END SELECT

	Channel% = Channel% - 1
	Word% = 0
	IF ChanMode% = 1 THEN
		Bit = Channel% AND &H1
		IF Bit <> 0 THEN
			Word% = Word% OR &H4
		END IF
		Bit = Channel% AND &H2
		IF Bit <> 0 THEN
			Word% = Word% OR &H1
		END IF
		Bit = Channel% AND &H4
		IF Bit <> 0 THEN
			Word% = Word% OR &H2
		END IF
	ELSE
		Word% = Channel%
	END IF
	Word% = Word% * 16
	ChanMode% = ChanMode% * 4
	Word% = Word% OR ChanMode%
	Word% = Word% OR &H8A

	ControlReg% = ControlReg% OR &H2 'Bring CS Low
	OUT LPTData%, &H0               'SCLK Low, DIN Low */
	OUT LPTControl%, ControlReg%    'Bring CS Low */
	Mask = &H80
	FOR i = 0 TO 7                  ' send the control word */
		Bit = Word% AND Mask
		IF Bit <> 0 THEN
			OUT LPTData%, &H2       'CS Low SCLK Low, DIN High */
			CALL AWait(gSpeed%)
			OUT LPTData%, &H3       'CS Low SCLK High, DIN High */
			CALL AWait(gSpeed%)
		ELSE
			OUT LPTData%, &H0       'CS Low SCLK Low, DIN Low */
			CALL AWait(gSpeed%)
			OUT LPTData%, &H1       'CS Low SCLK High, DIN Low */
			CALL AWait(gSpeed%)
		   END IF
		   Mask = Mask / 2
	NEXT i
	OUT LPTData%, &H0               'CS Low SCLK Low, DIN Low */
	CALL AWait(20 * gSpeed%)
	Word% = 0
	FOR i = 0 TO 11
		Word% = Word% * 2
		OUT LPTData%, &H1                                                                'Bring Clk High */
		CALL AWait(gSpeed%)
		OUT LPTData%, &H0       'Bring Clk Low */
		CALL AWait(gSpeed%)
		Bit = INP(LPTStatus%)   'read ADC's Data Out */
		Bit = Bit AND &H8
		IF Bit <> 0 THEN
			Word% = Word% OR &H1
		END IF
	NEXT i
	ControlReg% = ControlReg% AND &HFD
	OUT LPTControl%, ControlReg%  'Bring CS High */
	ReadADC = Word%
END FUNCTION

' The ReadAllDips function reads the four digital inputs 1-4
' and returns then as an integer with a value of 0 to 15
' depending on the state of the inputs
'
FUNCTION ReadAllDips
		OUT LPTData%, DataReg%  'ensure DOP's don't change
		ControlReg% = ControlReg% AND &HFE      'bring strobe low then high to latch the inputs */
		OUT LPTControl%, ControlReg%
		ControlReg% = ControlReg% OR &H1
		OUT LPTControl%, ControlReg%
		i% = INP(LPTStatus%)
		ip% = i% XOR &H80                                                                                 'invert the busy signal */
		ip% = ip% AND &HF0
		ip% = ip% / 16
		ReadAllDips = ip%
END FUNCTION

' The ReadDip function reads the state of a single digital input
' The number of the input is in "IONum" and can have a value of 1 to 4
' If IONum is not in the range of 1 to 4 then IErr% is set to non zero
FUNCTION ReadDIP (IONUM%)
		IErr% = 0
		IF IONUM% < 1 OR IONUM% > 4 THEN
			IErr% = 1
		END IF
		IF IErr% = 0 THEN
			OUT LPTData%, DataReg%  'ensure DOP's don't change
			ControlReg% = ControlReg% AND &HFE 'bring strobe low then high to latch the inputs */
			OUT LPTControl%, ControlReg%
			ControlReg% = ControlReg% OR &H1
			OUT LPTControl%, ControlReg%
			i% = INP(LPTStatus%)
			ip% = i% XOR &H80                                                                 'invert the busy signal */
			ip% = ip% AND &HF0
			Mask% = &H8
			FOR J% = 1 TO IONUM%
				Mask% = Mask% * 2
			NEXT J%
			ip% = ip% AND Mask%
			Bit% = 0
			IF ip% <> 0 THEN
				Bit% = 1
			END IF
		END IF
		ReadDIP = Bit%
END FUNCTION

' The WriteAllDOP function sets or resets the four digital outputs
' according to the value of "DOValue%"
' DOValue% can have the values 0 to 15
' If the value of DOValue% is out of range
' "IErr%" is set to non-zero.
'
SUB WriteAllDOP (DOValue%)
	IErr% = 0
	IF DOValue% < 0 OR DOValue% > 15 THEN
		IErr% = 1
	END IF
	IF IErr% = 0 THEN
		DataReg% = DOValue%
		OUT LPTData%, DataReg%
		ControlReg% = ControlReg% AND &HFE       'bring strobe low then high */
		OUT LPTControl%, ControlReg%
		ControlReg% = ControlReg% OR &H1
		OUT LPTControl%, ControlReg%
	END IF
END SUB

' The WriteDOP function sets or resets a single output "IONum"
' according to the value in "State".
' IONum can have the values 1 to 4
' State can be 0 or 1.
' If the value of State or IONum are out of the above ranges
' "IErr%" is set to non-zero.
'
SUB WriteDop (State%, IONUM%)
	IErr% = 0
	IF State% = 0 AND State% = 1 THEN
		IErr% = 1
	END IF
	IF IONUM% < 1 OR IONUM% > 4 THEN
		IErr% = 1
	END IF
	IF IErr% = 0 THEN
		Mask% = &H1
		IF IONUM% > 1 THEN
			FOR i% = 2 TO IONUM%
				Mask% = Mask% * 2
			NEXT i%
		END IF
		IF State% = 0 THEN
			Mask% = NOT Mask%
			DataReg% = DataReg% AND Mask%
		ELSE
			DataReg% = DataReg% OR Mask%
		END IF
		OUT LPTData%, DataReg%
		ControlReg% = ControlReg% AND &HFE       'bring strobe low then high */
		OUT LPTControl%, ControlReg%
		ControlReg% = ControlReg% OR &H1
		OUT LPTControl%, ControlReg%
	END IF
END SUB

