
'The procedures in this visual basic module uses procedures and functions
'from the vbasm.dll to read and write to the parallel port.
'read the file vbasm.txt for an explanation of the dll and include
'vbasm.bas in your program.
  
Option Explicit
Type Analog
    Label As String
    Channel As Integer
    ChanMode As Integer
    RawValue1 As Integer
    EngValue1 As Single
    RawValue2 As Integer
    EngValue2 As Single
    m As Single
    c As Single
    Units As String
    Log As Integer
End Type

Global Const NUM_AIP = 4
Global Const NUM_DIP = 4
Global Const NUM_DOP = 4
Global Const MAXTRENDSHEETS = 4
Global Const NUM_TREND_PTS = 200 'is equal to MAXTRENDSHEETS x Graph1.NumData
Global Const gNOTStarted = 0
Global Const gStarted = 1
Global Const gEND = 2
Global gcounter As Integer
Global gcounter1 As Integer
Global gSpeed&
'Printer Variables
Global LptNo%, LptPortAddr%
'Performance Variables
Global gADCCount, gADCRate
'Data Variables
Global AnalogRecord(1 To NUM_AIP) As Analog
Global APtr%, Period%, gPeriodUnit%
Global AIP(1 To NUM_AIP) As Integer
Global DIs(1 To NUM_DIP) As Integer
Global AIs(1 To NUM_AIP, 1 To NUM_TREND_PTS) As Single
Global gAIMax(1 To NUM_AIP) As Single
Global gAIMin(1 To NUM_AIP) As Single
Global gTimer%
Global gOldTime
Global gOldDOP As Integer, gDOP As Integer

'Trend Variables
Global StartPos%, EndPos%, gTrendNo%, TrendSheetNo%
Global gSourceFile$
Global gTrendInfo%(1 To 4, 1 To 4)

'Data Logging Variables
Global gLogTime, gLogDate, gLogOn As Integer
Global gLogFile$
Global gNewLogFile As Integer
'Global Start and Stop Logging Variables
Global gAnStartLogIP%, gAnStartLogStatus%, gStartLogAndOr%
Global gAnStopLogIP%, gAnStopLogStatus%, gStopLogAndOr%
Global gAnStartLogVal, gAnStopLogVal As Single
Global gStartLog, gLogMode, gLogSampleNo As Integer
Global gLogStartHours, gLogStartMins, gLogStartSecs, gLogSamples As Long
Global gLogStopHours, gLogStopMins, gLogStopSecs As Long



'Global ADC and Digital I/O Variables
Global LPTData%, LPTStatus%, LPTControl%
Global DataReg%, StatusReg%, ControlReg%, IErr%
Global gInputV%, gMeasureV%, gOffSetV%

Sub AWait (j&)
Dim i&
Dim k%
	'This procedure is a simple delay
	k% = 1
	For i& = 0 To j&
	    k% = k% + 1
	Next i&
End Sub

'This procedure uses the values obtained from the form
'SetStartLog. It checks AIP and DIP values to see if it is
'time to start logging
'
Sub CheckLogStatus ()
Dim AnStart
Dim TimeDay As Long
    If gLogMode = 0 Then
	gStartLog = gNOTStarted
	If gLogSampleNo = 0 Then 'Continuous sampling
	    gStartLog = gStarted
	    Exit Sub
	Else
	    'gLogSamples = gLogSamples + 1
	    If gLogSamples <= gLogSampleNo Then
		gStartLog = gStarted
		Exit Sub
	    Else
		gLogSamples = 0
		gLogOn = False
		Close #2 'Close the logging file
		Exit Sub
	    End If
	End If
    End If

    If gLogMode = 1 Then 'Log on the change of an Analog Value
	AnStart = False
	If gStartLog = gNOTStarted Then 'ie haven't started logging
	    'Check the Analog Condition First
	    If gAnStartLogIP% > 0 Then
		If gAnStartLogStatus% = True Then 'it is >
		    If AIs(gAnStartLogIP%, EndPos%) <= gAnStartLogVal Then
			AnStart = False
		    Else
			AnStart = True
		    End If
		Else 'it is <
		    If AIs(gAnStartLogIP%, EndPos%) >= gAnStartLogVal Then
			AnStart = False
		    Else
			AnStart = True
		    End If
		End If
	    End If
	    If AnStart = True Then
		gStartLog = gStarted
		'MsgBox "Started Logging"
	    End If
	
    
	Else
	    If gStartLog = gStarted Then 'Check if to stop logging
	    'Check the Analog Condition First
		If gAnStartLogIP% > 0 Then
		    If gAnStopLogStatus% = True Then 'it is >
			If AIs(gAnStartLogIP%, EndPos%) <= gAnStopLogVal Then
			    AnStart = False
			Else
			    AnStart = True
			End If
		    Else 'it is <
			If AIs(gAnStartLogIP%, EndPos%) >= gAnStopLogVal Then
			    AnStart = False
			Else
			    AnStart = True
			End If
		    End If
		End If
		If AnStart = True Then
		    gStartLog = gNOTStarted
		    'MsgBox "Stopped Logging"
		End If
	    End If
	End If
    End If
     If gLogMode = 2 Then 'Time of Day Logging
	gStartLog = gNOTStarted
	TimeDay = Timer
	If gLogStopSecs > gLogStartSecs Then
	    If gLogStartSecs <= TimeDay Then
		If gLogStopSecs >= TimeDay Then
		    gStartLog = gStarted
		End If
	    End If
	Else 'eg Start=23:00 End =5:00
	    If TimeDay >= gLogStartSecs Then
		gStartLog = gStarted
	    Else
		If TimeDay <= gLogStopSecs Then
		    gStartLog = gStarted
		End If
	    End If
	End If
    End If
End Sub

'This procedure clears the Trend
Sub ClearTrend ()
Dim i%, j%
    StartPos% = 1
    EndPos% = NUM_TREND_PTS
    For i% = 1 To NUM_AIP
	For j% = 1 To NUM_TREND_PTS
	    AIs(i%, j%) = 0
	Next j%
    Next i%

End Sub

Function FindPCSpeed ()
Dim tv, tv1, Delay
Dim i&, j&
    'This routine finds the relative speed of the PC and
    'places it into the global variable gSpeed%
    'This variable is used in the timing to read and write
    'to the ADC
    'This routine should be the first called
    
    j& = 1000
    Do
	j& = j& * 10
	tv = Timer
	For i& = 1 To j&
	Next i&
	tv1 = Timer
    Loop While (tv1 - tv) < .1
    'MsgBox "TV=" & Str(tv) & " TV1=" & Str(tv1)
    j& = 2 * j& / (tv1 - tv)'Test will last approx two seconds
    tv = Timer
    For i& = 1 To j&
    Next i&
    tv1 = Timer
    Delay = j& / (tv1 - tv)
    If Delay > 500000 Then  'Each clk cycle for the ADC with be >4usec period
	gSpeed& = .000002 * Delay + 1
    Else
	gSpeed& = 1
    End If
    gSpeed& = gSpeed& * 3
    FindPCSpeed = Delay
End Function

Function InitPrinterPort (LPTPortAdd%)
' The function InitPrinterPort initialises the printer port used to control
' the Pocket Sampler.
' LPTPortAdd is used as the base address
' If "LPTNo" is out of range "IErr%" is set to non-zero.
'
    IErr% = 0
    If LPTPortAdd% >= &H200 And LPTPortAdd% < &H400 Then
	LPTData% = LPTPortAdd%
    Else
	IErr% = 1
    End If
    If IErr% = 0 Then
	LPTStatus% = LPTData% + 1
	LPTControl% = LPTData% + 2
	DataReg% = &HFF
	Call vbOut(LPTData%, DataReg%)

	ControlReg% = &H4    'CS,WR,RD Low
	Call vbOut(LPTControl%, ControlReg%)
    End If
    InitPrinterPort = IErr%
End Function

'Procedure to save all logged data to file
Sub LogData ()
Dim chStr$
Dim i%, j%, LogStatus%
    'Save the data to a comma delimited file
    If gLogOn = False Then Exit Sub
    Call CheckLogStatus
    If gLogOn <> False And gStartLog = gStarted Then
	gLogSamples = gLogSamples + 1
	j% = 0
	
	If gLogTime <> 0 Then  '0 is FALSE
	    chStr$ = Time$
	    chStr$ = chStr$ + ","
	End If
	If gLogDate <> 0 Then
	    chStr$ = chStr$ + Date$
	    chStr$ = chStr$ + ","
	End If
	Print #2, chStr$;
	For i% = 1 To NUM_AIP
	    If AnalogRecord(i%).Log <> False Then
		If j% = 1 Then
		    Print #2, ",";
		End If
		Print #2, AIs(i%, EndPos%);
		j% = 1
	    End If
	Next i%
	Print #2, ""
    End If
End Sub

Function ReadADC (Addr As Integer, NoReads As Integer) As Integer
'Note the functions FindPCSpeed and InitPrinterPort
' must be called once before this function can be called.
' This function reads the ADC0804
Dim Bit%, Reading%, Found%, i%, j%, Total%
    Total% = 0
    If NoReads% > 128 Then NoReads% = 128
    If NoReads% < 1 Then NoReads% = 1
    Bit% = InitPrinterPort(Addr)
    If Bit% <> 0 Then Exit Function

    For j% = 1 To NoReads
	Found% = 0
	Call vbOut(LPTControl%, 4)                 'CS,RD,WR Low
	Call AWait(gSpeed&)
	Call vbOut(LPTControl%, 2)                ' CS Low and WR High and RD High
	Call vbOut(LPTControl%, 3)                ' CS Low and WR Low and RD High
	Call vbOut(LPTControl%, 6)                ' CS Low and WR High and RD High
	i% = i% + 1
	While Found% = False And i% < 1000
	    Bit% = vbINP(LPTStatus%)     ' Check For ADC's Finished
	    Bit% = Bit% And 8
	    If (Bit% = 0) Then Found% = 1
	    AWait (gSpeed&)
	    i% = i% + 1
	Wend
	If Found% = 1 Then
	    Call vbOut(LPTControl%, 2)         ' CS and RD Low
	    Reading% = vbINP(LPTStatus%)' Check For ADC's Finished
    
	    Call vbOut(LPTControl%, 3)         'CS Low and WR Low
	    Bit% = vbINP(LPTStatus%)     ' Check For ADC's Finished
	   
	    Call vbOut(LPTControl%, 4)        ' CS, WR, RD High
	    Reading% = Reading% And &HF0
	    Reading% = Reading% / 16
	    Reading% = Reading% And &HF
	    Bit% = Bit% And &HF0      'And it with FOH
	    Reading% = Reading% Or Bit%
	    Reading% = Reading% Xor &H88
	    Total% = Total% + Reading%
	Else
	    Reading% = -1
	    Call vbOut(LPTControl%, 4)        ' CS, WR, RD High
	End If
    Next j%
    ReadADC = Total% / NoReads%
    
End Function

