{==================================================================
 Pascal Routines for the Pocket Sampler
 Author Peter Simmonds
 Date   1st Febuary 1997
 Company  Ocean Controls
 ==================================================================}

PROGRAM  SampleProgram;

Uses
    Crt,
    Dos;


const
      TIMEDELAY=200;

var
 i,j,k,m,n,Min,Max :INTEGER; {These variables are used by the sample program}
 Volts:REAL;
 LPTData,LPTStatus,LPTControl :INTEGER; {These variables are global and used by functions}
 DataReg,StatusReg,ControlReg :BYTE;
 gSpeed,Range :INTEGER;

{===================================================================}
PROCEDURE AWait(j:INTEGER);
var
	i :INTEGER;
    k:LONGINT;
BEGIN
    k:=0;
	for i:=1 to j do
        BEGIN
        k:=k+1;
        END

END;



{ ===================================================================
 The ReadADC function reads the ADC0804
 If the function cannot find the ADC it returns -1
 The function reads the ADC a number of times as determined by the
 variable "Reads" and then averages it
}

FUNCTION ReadADC(Reads:INTEGER) :INTEGER;
var
    Bit, Reading, Found,i,j,Total :INTEGER;
BEGIN
    Total:=0;
    if (Reads>128) then Reads:=128;
    if (Reads<1) then Reads:=1;
    For j:=1 to Reads do
        BEGIN
	    Found:=0;
        Port[LPTControl]:=04;            { CS,WR,RD High }
        AWait(gSpeed);
        Port[LPTControl]:=02;            { CS Low }
        Port[LPTControl]:=03;          { CS Low and WR Low }
        Port[LPTControl]:=06;    { CS Low and RD Low }
        i:=0;

        while ((Found=0) and (i<40)) Do
		      BEGIN
              Bit:=Port[LPTStatus];        { Check For ADC's Finished }
              Bit:=Bit and 08;
              if (Bit=0) then Found:=1;
              AWait(gSpeed);                { Wait 400usecs ie gSpeed*40 }
              i:=i+1;
              END;
        if (Found=1) then
            BEGIN
            Port[LPTControl]:=02;    { CS Low }
            Reading:=Port[LPTStatus];        { Check For ADC's Finished }
            Reading:=Reading And 240;
		    Reading:=Reading DIV 16;
		    Reading:=Reading AND 15;

		    Port[LPTControl]:=03;    { CS Low and WR Low }
		    Bit:=Port[LPTStatus];        { Check For ADC's Finished }
		    Bit:=Bit and 240;
		    Reading:=Reading or Bit;
		    Reading:=Reading xor 136;
		    Port[LPTControl]:=3;    { CS, WR,Low RD High }
            writeln('ADC Reading=',Reading);
		    END
        else
		    BEGIN
		    Reading:=-1;
		    Port[LPTControl]:=3;    { CS, WR,Low RD High }
		    END;
        Total:=Total+Reading;
    END;
    ReadADC:=Total Div Reads;
END;

{ ===================================================================
  A routine to determine the speed of the PC so that delays can be
  calculated for reading the ADC
}

{ ===================================================================}
{ routine to produce a msec delay times iS                           }
PROCEDURE mSecDelay(iS : Word);
var
j,k,l:WORD;
   BEGIN
   for j:=1 to iS do
	   BEGIN
	   for l:=1 to 100 do   { the msec loop }
		   BEGIN
		   AWait(gSpeed);    { the 10uSecs loop }
		   END
	   END;
END;

{ ===================================================================
  A routine to determine the speed of the PC so that delays can be
  calculated for reading the ADC
}
PROCEDURE FindPCSpeed;
var
  iStart,iEnd:LONGINT;
  Hrs,Mins,Secs,HSecs:WORD;
  rdiff,timedelay: REAL;
  i,j,k:LONGINT;
BEGIN
    j:=100000;
    rdiff:=0;
    while (rdiff<0.2) do
	BEGIN
        k:=0;
	    GetTime(Hrs,Mins,Secs,HSecs);
	    iStart:=Secs*100+HSecs;
	    for i:=0 to j do k:=k+1;
	    GetTime(Hrs,Mins,Secs,HSecs);
	    iEnd:=Secs*100+HSecs;
	    if (iEnd>=iStart) then
	       BEGIN
	       rdiff:=iEnd-iStart;
	       END
	    else
           BEGIN
		   rdiff:=iEnd+6000-iStart;
		   END;
	    rdiff:=rdiff/100;
	    if (rdiff<0.2) then j:=j*10;
       END;  {end while}
    k:=Round(3.0/rdiff); { Determine the number of counts to do in 3 seconds }
    j:=j*k;
    k:=0;
    GetTime(Hrs,Mins,Secs,HSecs); { Get the start time }
    iStart:=Secs*100+HSecs;
    for i:=0 to j do
        BEGIN
        k:=k+1;      { Do the counting }
        END;
    GetTime(Hrs,Mins,Secs,HSecs); { Get the end time }
    iEnd:=Secs*100+HSecs;
    if (iEnd>=iStart) then
       BEGIN
       rdiff:=iEnd-iStart;
       END
    else
       BEGIN
       rdiff:=iEnd+6000-iStart;
       END;
    rdiff:=rdiff/100;             { Get the time elapsed in secs }
	timedelay:=rdiff/k;
	if (timedelay<0.00001) then   { if the timedelay is under 2uSecs get a value for gSpeed }
	   BEGIN
	   gSpeed:=Round(0.00001/timedelay+1);
	   END
	else gSpeed:=1;   { otherwise let gSpeed = 1}
	Writeln('PCs Speed.');
	Writeln('===========');
	Writeln('Number of loops in AWait Function for 10usecs delay is =', gSpeed);
    mSecDelay(3000);
END;


{===================================================================}
{ The function InitPrinterPort initialises the printer port used to control
 * the pocket sampler.
 * "LPTPortAdd" must be between 200H and 400H
 * If "LPTPortAdd" is out of range "err" is set to -1.
 }
PROCEDURE InitPrinterPort(LPTPortAdd:INTEGER);
var
   err:INTEGER;
BEGIN
  err:=0;
    if((LPTPortAdd>=512) and (LPTPortAdd<1024)) then
        BEGIN
	    LPTData:=LPTPortAdd;
        END
	ELSE
        BEGIN
	    err:=-1;
        END;

	if(err=0) then
    	BEGIN
	    LPTStatus:=LPTData+1;
        LPTControl:=LPTData+2;
        DataReg:=255;
        Port[LPTData]:=DataReg;
        ControlReg:=4;         { CS,WR,RD Low }
        Port[LPTControl]:=ControlReg;
        END
END;

{===================================================================
 A routine to determine the voltage range of the Pocket Sampler
 Range is 0=0-2V, not 0=0-20V
}
PROCEDURE FindVoltsRange;
BEGIN
	ControlReg:=1;         { CS,RD High WR Low }
	Port[LPTControl]:=ControlReg;
	Range:=Port[LPTStatus];
	Range:=Range And 128;
	ControlReg:=0;         { CS,RD,WR High }
	Port[LPTControl]:=ControlReg;
END;



{ ===================================================================
 Main Part of the Program
}
BEGIN
    clrscr;
    Writeln('Calculating Speed of PC');
    FindPCSpeed;
    Writeln;
    Writeln('Which printer port is the pocket sampler connected to 1 or 2 ');
    Readln(k);
    if k=1 then InitPrinterPort(888);  {Set up Printer Port 1 ie 378H }
    if k=2 then InitPrinterPort(632);  {Set up Printer Port 2 ie 278H }
    FindVoltsRange;
    Min:=255;
    Max:=0;
    m:=0;
    for k:=1 to 2000 do
    	BEGIN
        clrscr;
        Writeln('***** Read the ADC *****');
        i := ReadADC(16);
        if m>20 then
           BEGIN
           Min:=i;
           Max:=i;
           m:=0;
           END;
        m:=m+1;
        if (i<Min)  then Min:=i;
        if (i>Max)  then Max:=i;
        Volts:=i;
        Volts:=Volts*2.0/255.0;
        if (Range<>0) then Volts:=Volts*10.0;
        Writeln ('Sample No.=',k, '  Average ADC Reading=',i,'  Volts=',Volts);
        Writeln ('Max/Min Count=',m,'  Min=',Min,' Max=',Max);
        mSecDelay(500);
    END
END.
