/*==================================================================*/
/* C Routines for the Pocket Sampler                                */
/* Author Peter Simmonds                                            */
/* Date   31st Jan 1997                                             */
/* Company Ocean Controls                                           */
/*==================================================================*/
#include <time.h>

#define FALSE     0
#define TRUE      1

void InitPrinterPort(int LPTPortAdd,int *error);
void FindPCSpeed();
int ReadADC();
void AWait(int j);
void FindVoltsRange();
void main();

int LPTData,LPTStatus,LPTControl;
unsigned char DataReg,StatusReg,ControlReg;
int gSpeed,Range;



void main()
{
int i,k,m,Err;
int Min,Max;
float Volts,VOLT_SPAN,GAIN;

	VOLT_SPAN=2.47;
	GAIN=1; /* 2.3/2.325;*/
	clrscr();
	FindPCSpeed();
	printf("\n Which Printer Port 1 or 2 - ");
	scanf("%d",&i);
	if (i==1) InitPrinterPort(0x378,&Err);
	if (i==2) InitPrinterPort(0x278,&Err);
	FindVoltsRange();
	m=0;
	Max=0;
	Min=255;
	for (k=1;k<2000;k++) {
		clrscr();
		printf("***** Read The ADC *****\n");
		i = ReadADC(16);
		if (i<Min)  Min=i;
		if (i>Max)  Max=i;
		m=m+1;
		if (m>20) {
			m=0;
			Min=i;
			Max=i;
			}
		Volts=((float)i*VOLT_SPAN*GAIN/255.0);
		if (Range!=0) Volts=Volts*10.0;
		printf("Sample No.%d   Average ADC Reading =%d   Volts=%fV\n",k, i,Volts);
		printf("Max/Min Count=%d  Min=%d  Max=%d\n",m,Min,Max);
		delay(1000);
		}
}

/*===================================================================*/
/* A routine to determine the speed of the PC so that delays can be
   calculated for reading the ADC
*/
void FindPCSpeed()
{
clock_t start,end;
float diff,timedelay;
long int i,j,k;
	printf("Calculating Speed of PC\n");
	j=1000000;
	do {
		start=clock();
		for (i=0;i<j;i++) k=k+1;
		end=clock();
		diff=(float)((end-start)/CLK_TCK);
		if (diff<0.2)j=j*10;
		} while(diff<0.2);
	j=(long int)((float)j*2.0/diff);
	start=clock();
	for (i=0;i<j;i++) k=k+1;
	end=clock();
	diff=(float)((end-start)/CLK_TCK);
	timedelay=diff/(float)i;
	if (timedelay<0.00001) {
		gSpeed=0.00001/timedelay+1;
		}
	else {
		gSpeed=1;
		}
	printf("\nPC's Speed.");
	printf("\n===========");
	printf("\nNumber of loops in AWait Function for 10usecs delay is =%d\n",gSpeed);
	delay(2000);
}

/*===================================================================*/
/* The ReadADC function reads the ADC0804
   The function reads the ADC a consecutive number of times "Reads"
   and then averages the readings
 */
int ReadADC(int Reads)
{
int Bit,Reading,Found,i,j,Total;
	Total=0;
	if (Reads>128) Reads=128;
	if (Reads<1) Reads=1;
	for (j=0;j<Reads;j++) {
		Found=FALSE;
		outportb(LPTControl,0x04);    /* CS, WR, RD High */
		AWait(gSpeed);
		outportb(LPTControl,0x02);    /* CS Low */
		outportb(LPTControl,0x03);    /* CS Low and WR Low */
		outportb(LPTControl,0x06);    /* CS Low and RD Low */
		i=0;
		while (Found==FALSE && i<30) {
			Bit=inportb(LPTStatus);        /* Check For ADC's Finished */
			Bit=Bit & 0x08;
			if (Bit==0) Found=TRUE;
			AWait(gSpeed);                /* Wait 300usecs ie gSpeed*30 */
			i=i+1;
			}
		if (Found==TRUE) {
			outportb(LPTControl,0x02);    /* CS Low */
			Reading=inportb(LPTStatus);        /* Check For ADC's Finished */
			Reading=Reading>>4;
			Reading=Reading & 0x0f;
			outportb(LPTControl,0x03);    /* CS Low and WR Low */
			Bit=inportb(LPTStatus);        /* Check For ADC's Finished */
			Bit=Bit & 0xf0;
			Reading=Reading | Bit;
			Reading=Reading ^0x88;
			printf("ADC Reading=%d\n",Reading);
			outportb(LPTControl,0x03);    /* CS, WR Low, RD High */
			}
		else {
			Reading=-1;
			outportb(LPTControl,0x03);    /* CS, WR Low, RD High */
			}
		Total=Total+Reading;
		}
	Reading=Total/Reads;
	return(Reading);

}


/*===================================================================*/
void AWait(int j)
{
int i,k;
	for(i=0;i<j;i++) k=k+1;
}


/*===================================================================*/
/* The function InitPrinterPort initialises the printer port used to control
 * the pocket sampler.
 * "LPTPortAdd" must be in the range of 200H and 400H
 */
void InitPrinterPort(int LPTPortAdd,int *error)
{

	if (LPTPortAdd>=0x200 && LPTPortAdd<0x400) {
		LPTData=LPTPortAdd;
		*error=0;
		}
	else *error=1;
	if(!(*error)) {
		LPTStatus=LPTData+1;
		LPTControl=LPTData+2;
		DataReg=0xff;
		outportb(LPTData,DataReg);  /* Apply Power to the Pocket Sampler */
		ControlReg=0x04;         /* CS,RD,WR High */
		outportb(LPTControl,ControlReg);
		}
}

/*===================================================================*/
/* A routine to determine the voltage range of the Pocket Sampler
   Range is 0=0-2V, not 0=0-20V
*/
void FindVoltsRange()
{
	ControlReg=0x01;         /* CS,RD High WR Low */
	outportb(LPTControl,ControlReg);
	Range=inportb(LPTStatus);
	Range=Range & 0x80;
	ControlReg=0x00;         /* CS,RD,WR High */
	outportb(LPTControl,ControlReg);

}
