DECLARE FUNCTION ReadADC! (Reads%)
'Basic Routines for the Pocket Sampler
'Author Peter Simmonds
'Date 1st Febuary 1997
'Company Ocean Controls


DECLARE SUB mSecDelay (Num%)
DECLARE FUNCTION ReadADC (NoRead%)
DECLARE FUNCTION InitPrinterPort (LPTPortAdd%)
DECLARE SUB FindPCSpeed ()
DECLARE SUB FindVoltsRange ()
DECLARE SUB AWait (j%)

COMMON SHARED LPTData%, LPTStatus%, LPTControl%
COMMON SHARED DataReg%, StatusReg%, ControlReg%, IErr%
COMMON SHARED gSpeed%, Range%
COMMON SHARED NL

'MAIN PART OF THE PROGRAM BEGINS HERE
CLS
INPUT "Which Printer Port is Pocket Sampler connected to 1 or 2 - ", p%
IF p% = 1 THEN i% = InitPrinterPort(&H378)
IF p% = 2 THEN i% = InitPrinterPort(&H278)
IF i% = 0 THEN
	PRINT
	PRINT "Wait Finding The PC's Speed"
	CALL FindPCSpeed
	CALL FindVoltsRange
	CALL mSecDelay(2000)
	CLS
	Min% = 256
	Max% = -1
	m% = 0
	FOR k% = 1 TO 20000
		CLS
		PRINT "***** Read the ADC *****"
		j% = ReadADC(16)
		IF j% < Min% THEN Min% = j%
		IF j% > Max% THEN Max% = j%
		m% = m% + 1
		IF m% >= 20 THEN
			m% = 0
			Min% = j%
			Max% = j%
		END IF
		Volts = j%
		Volts = Volts * 2 / 255
		IF Range <> 0 THEN Volts = Volts * 10
		PRINT "SAMPLE No.="; k%; "  Average ADC Reading="; j%; "  Voltage="; Volts
		PRINT "Max/Min Count="; m%; "  MIN="; Min%; "  MAX="; Max%
		CALL mSecDelay(500)
	NEXT k%
END IF
END

SUB AWait (j%)
	k% = 1
	FOR i% = 0 TO j%
		k% = k% + 1
	NEXT i%
END SUB

'===================================================================*/
' A routine to determine the speed of the PC so that delays can be
' calculated for reading the ADC
SUB FindPCSpeed
	j = 10000
	DO
		start = TIMER
		FOR NL = 0 TO j
		NEXT NL
		endt = TIMER
		Diff = endt - start
		IF Diff < .2 THEN j = j * 10
	LOOP WHILE Diff < .2
	j = j * 2 / Diff
	start = TIMER
	FOR NL = 0 TO j
	NEXT NL
	endt = TIMER
	timedelay = (endt - start) / NL
	IF (timedelay < .00001) THEN
		gSpeed = .00001 / timedelay + 1
	ELSE
		gSpeed = 1
	END IF
	PRINT "PC's Speed."
	PRINT "==========="
	PRINT "Number of loops in AWait Function for 10usecs delay is ="; gSpeed

END SUB

' A routine to determine the voltage range of the Pocket Sampler
' Range is 0=0-2V, not 0=0-20V
SUB FindVoltsRange
	ControlReg% = 1        ' CS,RD High WR Low
	OUT LPTControl%, ControlReg%
	Range% = INP(LPTStatus%)
	Range% = Range% AND &H80
	ControlReg% = 0       ' CS,RD,WR High
	OUT LPTControl%, ControlReg%
END SUB

' The function InitPrinterPort initialises the printer port used to control
' the pocket sampler.
' "LPTPortAdd" the port address must be between 200Hex and 400Hex
' If "LPTPortAdd" is out of range "IErr%" is set to non-zero.
'
FUNCTION InitPrinterPort (LPTPortAdd%)
	IErr% = 0
	IF LPTPortAdd% >= &H200 AND LPTPortAdd% < &H400 THEN
		LPTData% = LPTPortAdd%
	ELSE
		IErr% = 1
	END IF
	IF IErr% = 0 THEN
		OUT LPTData%, &HFF
		LPTStatus% = LPTData% + 1
		LPTControl% = LPTData% + 2
		ControlReg% = &H4             'CS,WR,RD High
		OUT LPTControl%, ControlReg%
	END IF
	InitPrinterPort = IErr%
END FUNCTION

SUB mSecDelay (Num%)
	FOR i% = 1 TO Num%
		FOR j% = 1 TO 100
		CALL AWait(gSpeed%)
		NEXT j%
	NEXT i%

END SUB

' The ReadADC function reads the ADC0804
' The function reads the ADC a number of times as determined by the variable
' "NoReads%" and then averages the ADC readings
FUNCTION ReadADC (NoReads%)
DIM Bit%, Reading%, Found%, Total%, j%
	Total% = 0
	IF NoReads% > 128 THEN NoReads% = 128
	IF NoReads% < 1 THEN NoReads% = 1
	FOR j% = 1 TO NoReads%
		OUT LPTControl%, 4               ' CS High and WR High and RD High
		AWait (gSpeed%)
		Found% = 0
		OUT LPTControl%, 2               ' CS Low and WR High and RD High
		OUT LPTControl%, 3               ' CS Low and WR Low and RD High
		OUT LPTControl%, 6               ' CS Low and RD Low
		i% = 0
		WHILE Found% = FALSE AND i% < 30
			Bit% = INP(LPTStatus%)     ' Check For ADC's Finished
			Bit% = Bit% AND 8
			IF (Bit% = 0) THEN Found% = 1
			AWait (gSpeed%)
			i% = i% + 1
		WEND
		IF Found% = 1 THEN
			OUT LPTControl%, 2        ' CS and RD Low
			Reading% = INP(LPTStatus%)' Check For ADC's Finished

			OUT LPTControl%, 3        'CS Low and WR Low
			Bit% = INP(LPTStatus%)     ' Check For ADC's Finished

			OUT LPTControl%, 3       ' CS, WR, RD High

			Reading% = Reading% AND &HF0
			Reading% = Reading% / 16
			Reading% = Reading% AND &HF
			Bit% = Bit% AND &HF0      'And it with FOH
			Reading% = Reading% OR Bit%
			Reading% = Reading% XOR &H88
			PRINT "ADC Reading="; Reading%
		ELSE
			Reading% = -1
			OUT LPTControl%, 3      ' CS, WR, RD High
		END IF
		Total% = Total% + Reading%
	NEXT j%
	ReadADC = Total% / NoReads%
END FUNCTION

